<!DOCTYPE html>
<html lang="<?php echo LANG;?>">
<head>
    <title><?php echo NAZWA_SYSTEMU;?></title>
    
    <meta charset="utf-8">
    <meta http-equiv="content-type" content="text/html;charset=utf-8" />
    <meta http-equiv="Expires" content="0" />
    <meta http-equiv="cache-control" content="no-cache" />
    <meta http-equiv="cache-control" content="no-store" />
    <meta http-equiv="cache-control" content="must-revalidate" />
    <meta http-equiv="pragma" content="no-cache" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="robots" content="noindex,nofollow" />
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="production/images/favicon.ico" />
    <link rel="stylesheet" type="text/css" href="production/fonts/css/font-awesome.min.css" />
    <link rel="stylesheet" type="text/css" href="production/css/bootstrap.min.css" />
    <link rel="stylesheet" type="text/css" href="production/css/animate.min.css" />
    <link rel="stylesheet" type="text/css" href="production/css/custom.css" />
    <link rel="stylesheet" type="text/css" href="production/css/icheck/flat/green.css" />
    <link rel="stylesheet" type="text/css" href="production/css/floatexamples.css" />
    <link rel="stylesheet" type="text/css" href="production/css/nprogress_2.0.css" />
    <link rel="stylesheet" type="text/css" href="production/css/index.css" />
    <link rel="stylesheet" type="text/css" href="production/css/icheck/flat/green.css" >
    <link rel="stylesheet" type="text/css" href="production/css/select/select2.min.css" />
    
    <?php include_once('production/lang-js.php'); ?>
    
    <script src="production/js/jquery-3.6.0.min.js"></script>
    <script src="production/js/bootstrap.min.js"></script>
    <script src="production/js/progressbar/bootstrap-progressbar.min.js"></script>
    <script src="production/js/chartjs/chart.min.js"></script>
    <script src="production/js/nicescroll/jquery.nicescroll.min.js"></script>
    <script src="production/js/easypie/jquery.easypiechart.min.js"></script>
    <script src="production/js/nprogress_2.0.js"></script>
    <script src="production/js/custom.js"></script>
    <script src="production/js/icheck/icheck.min.js"></script>
    <script src="production/js/index.js"></script>
    <script src="production/js/select/select2.min.js"></script>
    <script src="libs/datatable/dataTables-1.10.7.js"></script>
</head>
<body class="nav-md" data-crsftoken="<?php echo $app->getToken();?>">
    <div class="container body">
        <div class="main_container">
            <div class="col-md-3 left_col">
                <div class="left_col scroll-view">
                    <div class="navbar nav_title">
                        <a href="index.php" class="site_title"><i class="fa fa-envelope fa-spin"></i> <span><?php echo NAZWA_SYSTEMU;?></span></a>
                    </div>
                    <div class="clearfix"></div>

                    <!-- menu prile quick info -->
                    <div class="profile">
                        <div class="profile_pic">
                            <img src="production/images/img.jpg" alt="..." class="img-circle profile_img">
                        </div>
                        <div class="profile_info">
                            <span><?php echo WELCOME;?></span>
                            <h2><?php echo WELCOME_ASK;?></h2>
                        </div>
                    </div>
                    <!-- /menu prile quick info -->

                    <br />

                    <!-- sidebar menu -->
                    <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
                        <div class="menu_section">
                            <p>&nbsp;</p>
                            <h3><?php echo MAIN_MENU;?></h3>
                            <ul class="nav side-menu">
                                <li><a><i class="fa fa-home"></i> <?php echo START;?> <span class="fa fa-chevron-down"></span></a>
                                    <ul class="nav child_menu">
                                        <li><a href="index.php"><?php echo DASHBOARD;?></a></li>
                                    </ul>
                                </li>
                                <li><a><i class="fa fa-edit"></i> <?php echo EMAIL_ADRESSES;?> <span class="fa fa-chevron-down"></span></a>
                                    <ul class="nav child_menu">
                                        <li><a href="index.php?manage=recipient&action=list"><?php echo MENU_RECIPIENT_LIST;?></a></li>
                                        <li><a href="index.php?manage=recipient&action=add"><?php echo MENU_ADD_RECIPIENT;?></a></li>
                                        <li><a href="index.php?manage=recipient&action=check_verify_list"><?php echo MENU_BULK;?></a></li>
                                        <li><a href="index.php?manage=import_bridge&action=list"><?php echo MENU_BRIDGE;?></a></li>
                                        <li><a href="index.php?manage=recipient&action=import"><?php echo MENU_CSV_IMPORT;?></a></li>
                                        <li><a href="index.php?manage=recipient&action=export"><?php echo MENU_CSV_EXPORT;?></a></li>
                                        <li><a href="index.php?manage=tags&action=list"><?php echo MENU_TAG_LIST;?></a></li>
                                        <li><a href="index.php?manage=tags&action=add"><?php echo MENU_ADD_TAGS;?></a></li>
                                        <li><a href="index.php?manage=sender&action=list"><?php echo MENU_SENDERS_LIST;?></a></li>
                                        <li><a href="index.php?manage=sender&action=add"><?php echo MENU_ADD_SENDER;?></a></li>
                                        <li><a href="index.php?manage=campaign&action=unsubscribed"><?php echo MENU_UNSUBSCRIBED;?></a></li>
                                        <li><a href="index.php?manage=recipient&action=bounce"><?php echo MENU_BOUNCED;?></a></li>
                                        <li><a href="index.php?manage=blacklist&action=list"><?php echo MENU_BLACKLIST;?></a></li>
                                    </ul>
                                </li>
                                <li><a><i class="fa fa-desktop"></i> <?php echo MENU_TEMPLATES;?> <span class="fa fa-chevron-down"></span></a>
                                    <ul class="nav child_menu">
                                        <li><a href="index.php?manage=templates&action=list"><?php echo MENU_TEMPLATES_LIST;?></a></li>
                                        <li><a href="index.php?manage=templates&action=add"><?php echo MENU_TEMPLATES_ADD;?></a></li>
                                        <li><a href="index.php?manage=media&action=list"><?php echo MENU_TEMPLATES_ATTACHMENTS;?></a></li>
                                        <li><a href="index.php?manage=templates_thumb&action=list"><?php echo MENU_TEMPLATES_THUMBNAILS;?></a></li>
                                    </ul>
                                </li>
                                <li><a><i class="fa fa-table"></i> <?php echo MENU_CAMPAIGNS;?> <span class="fa fa-chevron-down"></span></a>
                                    <ul class="nav child_menu">
                                        <li><a href="index.php?manage=campaign&action=prepare"><?php echo MENU_CAMPAIGNS_ADD;?></a></li>
                                        <li><a href="index.php?manage=campaign&action=waiting"><?php echo MENU_CAMPAIGNS_WAITING_LIST;?></a></li>
                                        <li><a href="index.php?manage=campaign&action=proceed"><?php echo MENU_CAMPAIGNS_IN_PROGRESS;?></a></li>
                                        <li><a href="index.php?manage=campaign&action=sent"><?php echo MENU_CAMPAIGNS_SENT;?></a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                        <div class="menu_section">
                            <h3><?php echo MENU_SYSTEM_CONFIGURATION;?></h3>
                            <ul class="nav side-menu">
                                <li><a><i class="fa fa-cogs"></i> <?php echo MENU_SETTINGS;?> <span class="fa fa-chevron-down"></span></a>
                                    <ul class="nav child_menu">
                                        <li><a href="index.php?manage=settings&action=credentials"><?php echo MENU_LOGIN;?></a></li>
                                        <li><a href="index.php?manage=settings&action=db"><?php echo MENU_DB;?></a></li>
                                        <li><a href="index.php?manage=settings&action=system"><?php echo MENU_SYSTEM_PARAMS;?></a></li>
                                        <li><a href="index.php?manage=smtp&action=list"><?php echo MENU_SMTP_PARAMS;?></a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                        <div class="menu_section">
                            <h3><?php echo MENU_SPECIALS;?></h3>
                            <ul class="nav side-menu">
                                <li><a><i class="fa fa-bug"></i> <?php echo MENU_ADDONS;?> <span class="fa fa-chevron-down"></span></a>
                                    <ul class="nav child_menu">
                                        <li><a href="index.php?manage=addons&action=subscribe_widget"><?php echo MENU_SUBSCRIBE_WIDGET;?></a></li>
                                        <li><a href="index.php?manage=addons&action=clear_db"><?php echo MENU_CLEAR_DB;?></a></li>
                                        <li><a href="index.php?manage=addons&action=import_templates"><?php echo MENU_IMPORT_TEMPLATES;?></a></li>
                                        <li><a href="index.php?manage=addons&action=import_sample_data"><?php echo MENU_IMPORT_DATA;?></a></li>
                                        <li><a href="index.php?manage=addons&action=faq"><?php echo MENU_FAQ;?></a></li>
                                        <li><a href="docs/index.html" target="_blank"><?php echo MENU_DOCS;?></a></li>
                                        <li><a href="index.php?manage=addons&action=about"><?php echo MENU_ABOUT;?></a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <!-- /sidebar menu -->

                    <!-- /menu footer buttons -->
                    <div class="sidebar-footer ">
                        <a href="index.php?manage=recipient&action=add" data-toggle="tooltip" data-placement="top" title="<?php echo MENU_ADD_RECIPIENT;?>"><span class="fa fa-edit" aria-hidden="true"></span></a>
                        <a href="index.php?manage=templates&action=add" data-toggle="tooltip" data-placement="top" title="<?php echo MENU_TEMPLATES_ADD;?>"><span class="fa fa-desktop" aria-hidden="true"></span></a>
                        <a href="index.php?manage=campaign&action=prepare" data-toggle="tooltip" data-placement="top" title="<?php echo MENU_CAMPAIGNS_ADD;?>"><span class="fa fa-table" aria-hidden="true"></span></a>
                        <a href="index.php?action=logout" data-toggle="tooltip" data-placement="top" title="<?php echo LOGOUT;?>"><span class="fa fa-power-off" aria-hidden="true"></span></a>
                    </div>
                    <!-- /menu footer buttons -->
                </div>
            </div>

            <!-- top navigation -->
            <div class="top_nav">
                <div class="nav_menu">
                    <nav class="" role="navigation">
                        <div class="nav toggle">
                            <a id="menu_toggle"><i class="fa fa-bars"></i></a>
                        </div>
                        <ul class="nav navbar-nav navbar-right">
                            <li><a href="index.php?action=logout"><button class="btn btn-dark btn-xs"><?php echo LOGOUT;?></button></a></li>
                        </ul>
                    </nav>
                </div>
            </div>
            <!-- /top navigation -->

            <!-- page content -->
            <div class="right_col" role="main">
                <?php if (DEMO_MODE) { ?>
                    <div role="alert" class="alert alert-danger">
                        <span aria-hidden="true" class="glyphicon glyphicon-exclamation-sign"></span>
                        <span class="sr-only"><?php echo ERROR;?></span>
                        <b><?php echo WARNING;?></b> <?php echo D_MODE;?>
                    </div>
                <?php } ?>
                <?php
                    if (!preg_match("/^([a-f0-9]{8})-(([a-f0-9]{4})-){3}([a-f0-9]{12})$/i", Settings::$ecode) && !DEMO_MODE) {
                         $app->changeSetting('euser', '');
                        ?>
                        <p>&nbsp;</p>
                        <div class="alert alert-danger" role="alert">
                            <p>
                                <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                                <span class="sr-only"><?php echo ERROR;?></span>
                                <b><?php echo WARNING;?></b> 
                                <?php echo S_DIS;?> ><a href="install.php?checkcode"><?php echo HERE;?></a><
                            </p>
                        </div>
                        <?php
                    }
                ?>
                <?php include('components/'.$app->manage.'/controller.php'); ?>
                <!-- footer content -->
                <footer>
                    <div class="">
                        <p class="pull-right">2016 - <?php echo @date("Y");?> &copy; All right reserved. <?php echo DEMO_MODE ? "DEMO MODE " : "" ;?>| v.<?php echo $app->version;?>, dev. by <a href='http://www.pklopotowski.pl' target='_blank'>www.pklopotowski.pl</a>
                            <span class="lead"> <a href='mailto:webmaster@pklopotowski.pl'><i class="fa fa-envelope-o"></i></a> </span>
                            <?php echo Settings::$euser !='' ? "Licensed to ".Settings::$euser."" : (DEMO_MODE ? "" : "not licensed") ;?>
                        </p>
                    </div>
                    <div class="clearfix"></div>
                </footer>
            <!-- /footer content -->
            </div>
            <!-- /page content -->
        </div>
    </div>

    <div id="custom_notifications" class="custom-notifications dsp_none">
        <ul class="list-unstyled notifications clearfix" data-tabbed_notifications="notif-group"></ul>
        <div class="clearfix"></div>
        <div id="notif-group" class="tabbed_notifications"></div>
    </div>
    <!-- /footer content -->
</body>
</html>
