<?php
/*
* defined('_MAILING') or die('Restricted access');
* antyhacker, add this line to all files
*/
define('_MAILING', 1);

// start session
session_start();

// report all errors
ini_set('error_reporting', E_ALL);

// set true/false
define('DEMO_MODE', false);
define('DEBUG', false);

// get configuration
include("configuration.php");

// in case of misspelled the timezone identifier on hosting server
ini_get('date.timezone') == '' && date_default_timezone_set(Settings::$timezone);

// get table prefix
define('PREF', Settings::$tbPrefix);

// set http/https protocol usage
define('HTTP', Settings::$useHTTPS == '1' ? 'https' : 'http');

// set timeout limit & max execution time
set_time_limit((int)(Settings::$phpTimeOutLimit));
ini_set('max_execution_time', (int)(Settings::$phpTimeOutLimit));

// get and run emailer class
include("php/class.emailer.php");
$app = new Emailer();

// database connectior
include("php/db_connector.php");

// go to campaign component without view rendering in some cases
if (
    $app->track || 
    $app->unsubscribe || 
    $app->subscribe || 
    $app->subscribeConfirm || 
    $app->click || 
    $app->browserview || 
    $app->stop || 
    $app->cron
    ) {
    include('components/campaign/controller.php');
}

// language & login/logout support
$app->run && $app->loadLanguage();
$app->login && $app->login();
$app->logout && $app->logout();

// check if component really exist, if not load home page (in case of wrong urls)
if ($app->component) {
    try {
        include('components/'.$app->manage.'/controller.php');
    } catch (Exception $e) {
        echo 'ERROR: ',  $e->getMessage(), "\n";
    }
} else {
    $check = $_SERVER['DOCUMENT_ROOT'].dirname($_SERVER['SCRIPT_NAME']).DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.$app->manage.DIRECTORY_SEPARATOR.'/controller.php';
    file_exists($check) ? include('production/index.php') : header("Location: index.php");
}

// check for any arrors and write them to log file
$err = error_get_last();
if (isset($err['type'])) {
    $app->saveLog(" TYPE:".$err['type']." MESSAGE:".$err['message']." FILE:".$err['file']." LINE:".$err['line']."\n");
}
    
