<?php

defined('_MAILING') or die('Restricted access');

$i = 0;
$template_head = '';
$template_body = '';
$server_select = Settings::$useSMTP != "0" ? "" : "<option value='0' selected>PHP mail()</option>";

$result = $db->query("
    SELECT
        t.id,
        t.thumb_filename as thumb,
        t.date_create,
        t.date_modify,
        t.name,
        t.subject,
        (
            SELECT group_concat(ta.filename SEPARATOR ',<br>') AS atts 
            FROM ".PREF."_template_att_conn AS tac
            left join ".PREF."_template_att AS ta on(tac.id_att = ta.id)
            where t.id = tac.id_template
        ) AS attachments
    FROM 
        ".PREF."_template AS t
");

$template_head .= "<tr><th>#</th><th>".TEMPLATES_THUMB."</th><th>".TEMPLATES_NAME."</th><th>".TEMPLATES_MAIL_TITLE."</th><th>".FILE_MANAGEMENT."</th><th>".CREATED."</th><th>".MODIFIED."</th><th></th></tr>";

foreach ($result as $row) {
    $thumb_filename = $row['thumb'];
    $i++;
    $template_body .= "<tr>
        <td>".$i."</td>
        <td><a href='index.php?manage=templates&action=edit&id=".$row['id']."'><img src='uploads/".$thumb_filename."'></a></td>
        <td><a href='index.php?manage=templates&action=edit&id=".$row['id']."'>".$row['name']."</a></td>
        <td><a href='index.php?manage=templates&action=edit&id=".$row['id']."'>".$row['subject']."</a></td>
        <td>".$row['attachments']."</td>
        <td>".$row['date_create']."</td>
        <td>".$row['date_modify']."</td>
        <td class='buttons'>
            <p><button type='button' class='btn btn-primary btn-xs pull-right' data-toggle='modal' data-target='#templateTest' data-templateid='".$row['id']."' >".TEST."</button></p>
            <p>&nbsp;</p>
            <p><button type='button' class='btn btn-warning btn-xs pull-right' data-toggle='modal' data-target='#templateCopy' data-templateid='".$row['id']."' data-templatename='".$row['name']."' >".COPY."</button></p>
            <p>&nbsp;</p>
            <p><button type='button' class='btn btn-danger btn-xs pull-right' data-toggle='modal' data-target='#templateDelete' data-templatesubject='".$row['subject']."' data-templateid='".$row['id']."' >".DELETE."</button></p>
        </td>
    </tr>";
}

// choose sending server
$serverEmailSenderID = Settings::$serverEmailSenderID;
if ((int)(Settings::$useSMTP)) {
    //$selected = $serverEmailSenderID == '0' ? "selected" : "";
    $server_select = "<option> - select smtp server - </option>";
    
    $result = $db->query(" SELECT * FROM ".PREF."_smtp ");
    foreach ($result as $row) {
        //$selected = $serverEmailSenderID == $row['id'] ? "selected" : "";
        //$server_select .= "<option value='".$row['id']."' ".$selected.">".$row['name']."&nbsp;-&nbsp;".$row['host']."</option>";
        $server_select .= "<option value='".$row['id']."' >".$row['name']."&nbsp;-&nbsp;".$row['host']."</option>";
    }
}

?>

<div class="modal fade" id="templateTest" tabindex="-1" role="dialog" aria-labelledby="templateDeleteLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="templateDeleteLabel"><?php echo TESTING_TEMPLATE; ?></h4>
      </div>
        <form action="index.php?manage=templates&data=modify&action=test" method="post">
            <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
            <div class="modal-body">
                <input type="hidden" name="templateid" class="templateid" value="">
                <div class="form-group">
                    <label for="templatesubject" class="control-label"><?php echo TESTING_TEMPLATE_INFO; ?></label>
                    <input name="mailTo" type="text" class="form-control templatesubject" value="<?php echo Settings::$adminMail;?>">
                </div>
                <div class="form-group">
                    <label for="templatesubject" class="control-label"><?php echo TESTING_CHOOSE_SERVER; ?></label>
                    <select class="form-control" name="serverEmailSenderID" required>
                        <?php echo $server_select; ?>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CANCEL;?></button>
                <button type="submit" class="btn btn-danger" id="testTemplate"><?php echo SEND;?></button>
            </div>
        </form>
        <div id="response" class="modal-body">
            <div class="form-group">
                <p></p>
            </div>
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CLOSE;?></button>
        </div>
    </div>
  </div>
</div>

<div class="modal fade" id="templateCopy" tabindex="-1" role="dialog" aria-labelledby="templateCopyLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="templateCopyLabel"><?php echo COPYING; ?></h4>
      </div>
        <form action="index.php?manage=templates&data=modify&action=copy" method="post">
            <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
            <div class="modal-body">
                <input type="hidden" name="templateid" class="templateid" value="">
                <div class="form-group">
                    <label for="templatename" class="control-label"><?php echo TEMPLATES_NAME; ?></label>
                    <input type="text" class="form-control templatename" name="templatename" value="">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CANCEL;?></button>
                <button type="submit" class="btn btn-danger"><?php echo COPY;?></button>
            </div>
        </form>
    </div>
  </div>
</div>

<div class="modal fade" id="templateDelete" tabindex="-1" role="dialog" aria-labelledby="templateDeleteLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="templateDeleteLabel"><?php echo DELETING; ?></h4>
      </div>
        <form action="index.php?manage=templates&data=modify&action=delete" method="post">
            <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
            <div class="modal-body">
                <input type="hidden" name="templateid" class="templateid" value="">
                <div class="form-group">
                    <label for="templatesubject" class="control-label"><?php echo DELETING_CONFIRM_QUESTION; ?></label>
                    <input type="text" class="form-control templatesubject" disabled>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CANCEL;?></button>
                <button type="submit" class="btn btn-danger"><?php echo DELETE;?></button>
            </div>
        </form>
    </div>
  </div>
</div>

<div class="page-title">
    <div class="title_left">
        <h3><?php echo MENU_TEMPLATES;?> <small>(<?php echo TEMPLATES_LIST;?>)</small></h3>
    </div>
</div>
<div class="clearfix"></div>
<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2><?php echo TEMPLATES_TITLE;?></h2>
                <div class="clearfix"></div>
            </div>
            <div class="x_content">
                <table class="table table-striped responsive-utilities jambo_table" id="templates">
                    <thead>
                        <?php echo $template_head; ?>
                    </thead>
                    <tbody>
                        <?php echo $template_body; ?>
                    </tbody>
                </table>
            </div>
            <a href="index.php?manage=templates&action=add" class="btn btn-primary"><?php echo MENU_TEMPLATES_ADD;?></a>
        </div>
    </div>
</div>
<p>&nbsp;</p>

<script src="libs/datatable/dataTables-1.10.7.js"></script>
<script src="components/templates/view.templates.list.js"></script>
