"use strict";

$(document).ready(function() {

    $.fn.dataTableExt.oStdClasses.sPageButton = "btn btn-default";
    $('#templates').DataTable({
        stateSave: true,
        language: dataTableTranslation
    });
    
    $('#templateDelete').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var templatesubject = button.data('templatesubject');
        var templateid = button.data('templateid');
        var modal = $(this);
        modal.find('.templatesubject').val(templatesubject);
        modal.find('.templateid').val(templateid);
    });
    
    $('#templateCopy').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var templateid = button.data('templateid');
        var templatename = button.data('templatename');
        var modal = $(this);
        modal.find('.templateid').val(templateid);
        modal.find('.templatename').val(lang_copy + ' - ' + templatename);
        $('#response').css({display: 'none'}).html('');
    });
    
    $('#templateTest').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var templateid = button.data('templateid');
        var modal = $(this);
        modal.find('.templateid').val(templateid);
        $('#response').css({display: 'none'}).html('');
    });
    
    $('#testTemplate').on('click', function(event){
        var templateid = $('input[name=templateid]').val();
        var smtpid = $('select[name=serverEmailSenderID]').val();
        var mailTo = $('input[name=mailTo]').val();
        var csrf_token = $('input[name=csrf_token]').val();
        var button = $(this);
        
        button.addClass('disabled').removeClass('btn-primary').addClass('btn-warning');
        
        $('#response').css({display: 'none'}).html('');
        event.preventDefault();
        
        $.ajax({
            type : 'POST',
            url : 'index.php?manage=templates&adata=modify&action=test',
            async: true,
            data: {
                templateid : templateid,
                smtpid : smtpid,
                mailTo : mailTo,
                adata : '1',
                csrf_token : csrf_token,
            },
            success: function(response) {
                $('#response').css({display: 'block'}).html(response);
                button.removeClass('disabled').addClass('btn-primary').removeClass('btn-warning');
            }
        });
        
    });
    
});