"use strict";

$(document).ready(function () {
    var editor = $('#editor').val();
    
    $('#enable_editor').on('click', function(){
        initTinyEditor();
        disableTextareaWeight()
    });
    $('#disable_editor').on('click', function(){
        disableTinyEditor();
        textareaWeight();
    });
            
    if ($("input.flat")[0]) {
        $('input.flat').iCheck({
            checkboxClass: 'icheckbox_flat-green',
            radioClass: 'iradio_flat-green'
        });
    }
    if (editor == 'textarea') { 
        textareaWeight();
    }
    if (editor == 'tinymce') {
        initTinyEditor();
    }
    if (editor == 'codemirror') {
        initCodeMirrorHeader();
        initCodeMirrorBody();
    }
    
    $('#template_name').on('change update', function(){
        var img;
        img = $('option:selected', this).attr('data-imagesrc');
        if (img === undefined) {
            img = 'uploads/no-picture.png';
        }
        $('#layoutPicture').attr('src', img);
        console.log(img);
    });
});

function initTinyEditor() {
    tinymce.init({
        selector:'#mailhtml',
        height : "700",
        plugins: "link print preview code textcolor table image filemanager",
        toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | forecolor backcolor | link | image',
        language : lang,
        relative_urls : false,
        remove_script_host : false,
        init_instance_callback: function (editor) {
            editor.on('change keyup', function (e) {
                tinyWeight();
            });
        }
    });
    $('#enable_editor').addClass('hidden');
    $('#disable_editor').removeClass('hidden');
}
function tinyWeight() {
    var max = $('#totalLength').val(),
        x = tinyMCE.activeEditor.getContent().length,
        l = Math.ceil(x/max * 10000) / 100;
    $('#chars').html(x);
    $('#usage').html(l);
    $('#percentageWrapper div').css({'width': l + '%'});
}

function textareaWeight() {
    $('#mailhtml').on('keyup change', function() {
        var max = $('#totalLength').val(),
            x = $(this).val().length,
            l = Math.ceil(x/max * 10000) / 100;
        $('#chars').html(x);
        $('#usage').html(l);
        $('#percentageWrapper div').css({'width': l + '%'});
    });
}
function disableTextareaWeight() {
    $('#mailhtml').off();
}

function disableTinyEditor() {
    tinymce.remove('#mailhtml');
    $('#enable_editor').removeClass('hidden');
    $('#disable_editor').addClass('hidden');
}

function initCodeMirrorBody() {
    var editor = CodeMirror.fromTextArea(document.getElementById('mailhtml'), {
        lineNumbers: true,
        matchBrackets: true,
        mode: "text/html"
    });
    editor.on("change", function(e) {
        codeMirrorWeight(e.getValue().length);
    });
    
}

function initCodeMirrorHeader() {
    var editor = CodeMirror.fromTextArea(document.getElementById('header_html'), {
        lineNumbers: true,
        matchBrackets: true,
        mode: "text/html"
  });
}
function codeMirrorWeight(x) {
    var max = $('#totalLength').val(),
        l = Math.ceil(x/max * 10000) / 100;
    $('#chars').html(x);
    $('#usage').html(l);
    $('#percentageWrapper div').css({'width': l + '%'});
}