<?php

defined('_MAILING') or die('Restricted access');

$files_option = '';
$thumbs_option = '';

// get template details
$stmt = $db->prepare("
    SELECT
        t.id,
        t.subject,
        t.name,
        t.doctype,
        t.html_header,
        t.body_attribs,
        t.content_html,
        t.content_txt,
        t.thumb_filename,
        (
            SELECT group_concat(tc.id_att SEPARATOR ', ') AS atts 
            FROM ".PREF."_template_att_conn AS tc 
            WHERE t.id=tc.id_template
        ) AS attachments
    FROM 
        ".PREF."_template AS t
    WHERE 
        t.id=? 
");
$id = (int)($_GET['id']);
$stmt->bindParam(1, $id, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();

// in case you want to edit not existent data
if (! @$data = $row[0]){
    echo DATA_ERROR;
    exit();
}

$subject = $data['subject'];
$name = $data['name'];
$doctype = stripslashes($data['doctype']);
$html_header = stripslashes($data['html_header']);
$body_attribs = $data['body_attribs'];
$content_html = $data['content_html'];
$content_txt = $data['content_txt'];
$thumb_filename = $data['thumb_filename'];

// check attachments
$p_att = $data['attachments'] != '' ? explode(',',$data['attachments']) : [];
$files = $db->query(" SELECT * FROM ".PREF."_template_att order by filename asc ");
foreach ($files as $file) {
    $checked = in_array($file['id'],$p_att) ? " checked='checked' " : "" ;
    $files_option .= "<div class='checkbox'><label><input class='flat' type='checkbox' name='files[]' value='".$file['id']."' ".$checked.">&nbsp;".$file['filename']."</label></div>";
}

// get all tumbnails
$thumb_files = $db->query(" SELECT * FROM ".PREF."_template_thumb ");
$thumbs_option .= "<option value='no-picture.png' style='background-image:url(uploads/no-picture.png); '>no-picture.png</option>";
foreach ($thumb_files as $thumb_file) {
    $selected = ($thumb_file['filename'] == $thumb_filename) ? " selected " : "" ;
    $thumbs_option .= "<option data-imagesrc='uploads/".$thumb_file['filename']."' value='".$thumb_file['filename']."'".$selected." style='background-image:url(uploads/".$thumb_file['filename']."); '>".$thumb_file['filename']."</option>";
}

$editor = Settings::$systemEditor;


$stmt = $db->query(" SHOW FIELDS FROM ".PREF."_template ");
$stmt->execute();
$fields = $stmt->fetchAll();
foreach ($fields as $row) {
    //echo "field:".$row['Field']." type:".$row['Type']."<br>";
    if ($row['Field'] == 'content_html') {
        $fieldType = $row['Type'];
    }
}
switch (substr($fieldType, 0 , 4)) {
    case "medi":
        $totalLength = 16777215;
        break;
    case "long":
        $totalLength = 4294967295;
        break;
    case "text":
    case "blob":
        $totalLength = 65535;
        break;
    case "varc":
        $fieldType = str_replace("varchar(", "", $fieldType);
        $fieldType = str_replace(")", "", $fieldType);
        $totalLength = (int) $fieldType;
        break;
    default:
        $totalLength = 0;
}

$x = strlen($content_html);
$l = $x / $totalLength * 100;

?>
<input type="hidden" id="editor" value="<?php echo $editor;?>">

<div class="page-title">
    <div class="title_left">
        <h3><?php echo MENU_TEMPLATES;?> <small>(<?php echo TEMPLATES_TITLE_EDIT;?>)</small></h3>
    </div>
</div>
<div class="clearfix"></div>
<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2><?php echo TEMPLATES_TITLE_EDIT;?></h2>
                <div class="clearfix"></div>
            </div>
            <div class="x_content">
                <form class="form-horizontal" action="index.php?manage=templates&data=modify&action=update" method="post">
                    <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
                    <input type="hidden" name="id" value="<?php echo $id;?>">
                    <input type="hidden" id="totalLength" value="<?php echo $totalLength;?>">
                    <div class="form-group">
                    <label for="name"><?php echo TEMPLATES_NAME;?>*</label>
                        <input 
                            type="text" 
                            class="form-control" 
                            id="name" 
                            name="name" 
                            value="<?php echo $name; ?>"
                            placeholder="<?php echo TEMPLATES_NAME;?>"
                            required>
                    </div>
                    <div class="form-group">
                    <label for="subject"><?php echo TEMPLATES_MAIL_TITLE;?>*</label>
                        <input 
                            type="text" 
                            class="form-control" 
                            id="subject" 
                            name="subject" 
                            value="<?php echo $subject; ?>"
                            placeholder="<?php echo TEMPLATES_MAIL_TITLE_PLACEHOLDER;?>"
                            required>
                    </div>
                    
                    <div class="form-group email_header_div">
                        <label for="content_txt" >HTML header <code>&lt;<input id="doctype" type="text" name="doctype" placeholder="!DOCTYPE here..." value='<?php echo $doctype;?>' pattern="[^']*$">&gt;&lt;heaad&gt;...&lt;/head&gt;</code></label>
                        <textarea id="header_html" name="html_header" class="form-control"><?php echo $html_header; ?></textarea>
                    </div>
                    <div class="form-group">
                        <label for="content_html" ><?php echo TMPLATES_HTML;?><code>&lt;body <input id='body_attribs' type="text" name='body_attribs' placeholder='attribs here...' value='<?php echo $body_attribs;?>' pattern="[^']*$">&gt;...&lt;/body&gt;</code></label>
                        <?php if ($editor == 'tinymce') { ?>
                            <a id="disable_editor" class="btn btn-primary btn-xs pull-right hidden"><?php echo DISABLE_EDITOR;?></a>
                            <a id="enable_editor" class="btn btn-primary btn-xs pull-right hidden"><?php echo ENABLE_EDITOR;?></a>
                        <?php } ?>
                        <div id="percentageWrapper">
                            <p><?php echo TEMPLATE_STATISTICS;?> <?php echo TEMPLATE_CHARS;?>
                                <span id="chars"><?php echo $x;?></span> / <?php echo TEMPLATE_USAGE;?>
                                <span id="usage"><?php echo number_format($l, 2, ".", ".");?></span>%
                            </p>
                            <div style="width:<?php echo $l; ?>%;">
                            </div>
                        </div>
                        <textarea id="mailhtml" name="content_html" class="form-control"><?php echo $content_html; ?></textarea>
                    </div>
                    <div class="form-group">
                        <label for="content_html" ><?php echo TMPLATES_VARIABLES;?></label>
                        <p>{RECIPIENT_NAME}, {RECIPIENT_NAME_1}, {RECIPIENT_NAME_2}, {RECIPIENT_NAME_3}, {RECIPIENT_EMAIL}, {RECIPIENT_DESCRIPTION}, {UNSUBSCRIBE}, {BROWSER_VIEW}, {CAMPAIGN_NAME}, {SENDER_NAME}, {SENDER_EMAIL}, {CURRENT_YEAR}, {CURRENT_MONTH}, {CURRENT_DAY}, {F0}, {F1}, {F2}, {F3}</p>
                    </div>
                    <div class="form-group">
                        <label for="content_txt" ><?php echo TMPLATES_TXT;?></label>
                        <textarea id="mailtxt" name="content_txt" class="form-control"><?php echo $content_txt; ?></textarea>
                    </div>
                    <div class="form-group">
                        <label for="template_name" class="col-sm-2 control-label"></label>
                        <div class="col-sm-5">
                            <img id="layoutPicture" src="uploads/<?php echo $thumb_filename; ?>">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="tagsname" class="col-sm-2 control-label"><?php echo TEMPLATES_THUMB;?></label>
                        <div class="col-sm-5">
                            <select id="template_name" class="form-control" name="thumb">
                                <?php echo $thumbs_option; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="tagsname" class="col-sm-2 control-label"><?php echo MEDIA_MANAGER;?></label>
                        <div class="col-sm-5">
                            <?php echo $files_option; ?>
                        </div>
                    </div>
                    <div class="form-group">
                        <div>
                            <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-download"></i> <?php echo SAVE;?></button>
                            <span class="pull-right">&nbsp;</span>
                            <span class="pull-right">&nbsp;</span>
                            <span class="pull-right">&nbsp;</span>
                            <a class="btn btn-success pull-right" href="index.php?manage=templates&action=list"><i class="fa fa-frown-o"></i> <?php echo CANCEL;?></a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<link href="libs/codemirror/codemirror.css" rel="stylesheet">
<script src="libs/codemirror/codemirror.js"></script>
<script src="libs/codemirror/xml.js"></script>
<script src="libs/tinymce/tinymce.min.js"></script>
<script src="components/templates/view.templates.js"></script>
