<?php

defined('_MAILING') or die('Restricted access');

$i = 0;
$campaign_list = '';

$result = $db->query("
    SELECT
        c.id,
        c.name,
        c.recipient_qty,
        status,
        date_create,
        date_start,
        (
            SELECT count(crc.id_recipient) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id and crc.status IN('2','3')
        ) AS receivers,
        (
            SELECT count(crc.id_recipient) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id and crc.bounced='1'
        ) AS bounced,
        (
            SELECT count(crc.clicked) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id and crc.clicked != '0'
        ) AS clicked,
        (
            SELECT sum(crc.clicked) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id
        ) AS clicks,
        (
            SELECT count(crc.id_recipient) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id and crc.status='3'
        ) AS unsubscribers
    FROM 
        ".PREF."_campaign AS c
    WHERE
        c.status = '2'
    ORDER BY id DESC
");

foreach ($result as $row) {
    $i++;
    
    $number = ((int)($row['receivers']) / (int)($row['recipient_qty'])) * 100;
    $number = number_format($number, 2, ',', '');
    
    $number2 = ((int)($row['bounced']) / (int)($row['recipient_qty'])) * 100;
    $number2 = number_format($number2, 2, ',', '');
    
    $number3 = ((int)($row['clicked']) / (int)($row['recipient_qty'])) * 100;
    $number3 = number_format($number3, 2, ',', '');
    
    $number4 = ((int)($row['unsubscribers']) / (int)($row['recipient_qty'])) * 100;
    $number4 = number_format($number4, 2, ',', '');
    
    
    $campaign_list .= '
      <div>
        <div class="x_panel">
          <div class="x_title bg-custom">
            <h2>'.$row['name'].'</h2>
            <ul class="nav navbar-right panel_toolbox">
              <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a></li>
              <li><a class="close-link"><i class="fa fa-close"></i></a></li>
            </ul>
            <div class="clearfix"></div>
          </div>
          <div class="x_content">

            <div class="col-md-2">
                <div>'.CAMPAIGN_RECIPIENT_QTY.': '.$row['recipient_qty'].'</div>
                <div>'.OPENS.': '.$row['receivers'].'</div>
                <div>'.BOUNCED.': '.$row['bounced'].'</div>
                <div>'.UNIQUE_CLICKS.': '.$row['clicked'].'</div>
                <div>'.TOTAL_CLICKS.': '.$row['clicks'].'</div>
                <div>'.D_EMAIL_UNSUBSCIBERS.': '.$row['unsubscribers'].'</div>
                <div>'.CAMPAIGN_CREATED_DATE.': '.substr($row['date_create'], 0, 10).'</div>
                <div>'.SENT.': '.substr($row['date_start'], 0, 10).'</div>

            </div>
            <div class="col-md-2">
                <p>'.OPENS.'</p>
                <div class="pie_div">
                    <span class="chart" data-percent="'.$number.'"><span class="percent"></span></span>
                </div>
                <div class="pie_bg">
                    <canvas id="canvas_doughnut" height="130"></canvas>
                </div>
            </div>
            <div class="col-md-2">
                <p>'.BOUNCED.'</p>
                <div class="pie_div">
                    <span class="chart" data-percent="'.$number2.'"><span class="percent"></span></span>
                </div>
                <div class="pie_bg">
                    <canvas id="canvas_doughnut" height="130"></canvas>
                </div>
            </div>
            <div class="col-md-2">
                <p>'.CLICKED.'</p>
                <div class="pie_div">
                    <span class="chart" data-percent="'.$number3.'"><span class="percent"></span></span>
                </div>
                <div class="pie_bg">
                    <canvas id="canvas_doughnut" height="130"></canvas>
                </div>
            </div>
            <div class="col-md-2">
                <p>'.D_EMAIL_UNSUBSCIBERS.'</p>
                <div class="pie_div">
                    <span class="chart" data-percent="'.$number4.'"><span class="percent"></span></span>
                </div>
                <div class="pie_bg">
                    <canvas id="canvas_doughnut" height="130"></canvas>
                </div>
            </div>
            <div class="col-md-2">
                <p><button type="button" class="btn btn-danger btn-xs" data-toggle="modal" data-target="#campaignDelete" data-campaignname="'.$row['name'].'" data-campaignid="'.$row['id'].'" >'.DELETE.'</button></p>
            </div>

          </div>
        </div>
      </div>
    
    ';
    

    
}

?>

<div class="modal fade" id="campaignDelete" tabindex="-1" role="dialog" aria-labelledby="campaignDeleteLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="campaignDeleteLabel"><?php echo DELETING; ?></h4>
            </div>
            <form action="index.php?manage=campaign&data=modify&action=delete" method="post">
                <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
                <input type="hidden" name="back_to_sent" value="1">
                <div class="modal-body">
                    <input type="hidden" name="campaignid" class="campaignid" value="">
                    <div class="form-group">
                        <label for="campaignname" class="control-label"><?php echo DELETING_CONFIRM_QUESTION; ?></label>
                        <input type="text" class="form-control campaignname" disabled>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CANCEL;?></button>
                    <button type="submit" class="btn btn-danger"><?php echo DELETE;?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="page-title">
    <div class="title_left">
        <h3><?php echo MENU_CAMPAIGNS;?> <small>(<?php echo MENU_CAMPAIGNS_SENT;?>)</small></h3>
    </div>
</div>
<div class="clearfix"></div>

<?php
    echo $campaign_list;
?>


<p>&nbsp;</p>

<script src="components/statistics/view.statistics.js"></script>
