"use strict";

$(document).ready(function() {
    
    $('.chart').easyPieChart({
        easing: 'easeOutElastic',
        delay: 8000,
        barColor: '#26B99A',
        trackColor: '#eee',
        scaleColor: false,
        lineWidth: 20,
        trackWidth: 16,
        lineCap: 'butt',
        onStep: function(from, to, percent) {
            $(this.el).find('.percent').text(Math.round(percent));
        }
    });
    
    $('#campaignDelete').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var campaignname = button.data('campaignname');
        var campaignid = button.data('campaignid');
        var modal = $(this);
        modal.find('.campaignname').val(campaignname);
        modal.find('.campaignid').val(campaignid);
    })

// Panel toolbox
    $('.collapse-link').on('click', function() {
        var $BOX_PANEL = $(this).closest('.x_panel'),
            $ICON = $(this).find('i'),
            $BOX_CONTENT = $BOX_PANEL.find('.x_content');
        
        // fix for some div with hardcoded fix class
        if ($BOX_PANEL.attr('style')) {
            $BOX_CONTENT.slideToggle(200, function(){
                $BOX_PANEL.removeAttr('style');
            });
        } else {
            $BOX_CONTENT.slideToggle(200); 
            $BOX_PANEL.css('height', 'auto');  
        }

        $ICON.toggleClass('fa-chevron-up fa-chevron-down');
    });

    $('.close-link').on('click', function () {
        var $BOX_PANEL = $(this).closest('.x_panel');

        $BOX_PANEL.remove();
    });
});