"use strict";

$(document).ready(function(){
    
    // tab recipients
    $.fn.dataTableExt.oStdClasses.sPageButton = "btn btn-default";
    $('.site_title i').addClass('fa-spin');
    var oTable = $('#campaign').DataTable({
        stateSave: true,
        language: dataTableTranslation,
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "index.php?manage=statistics&data=modify&action=getlist",
            "type": "POST",
            "data":{
                 "csrf_token": $('#csrf_token').val(),
                 "id_campaign": $('#id_campaign').val(),
                 "recipient_status": $('#recipient_status').val()
            }, 
        },
        "columns": [
            { "data": "id" },
            { "data": "person" },
            { "data": "clicked" },
            { "data": "software" },
            { "data": "geodata" }
        ],
        "fnDrawCallback": function( oSettings ) {
          $('#recipient_qty').val( this.fnSettings().fnRecordsDisplay() );
          $('.site_title i').removeClass('fa-spin');
        }
        
    });
    
        $("div.dataTables_filter").append("<a id='mySearch' class='btn btn-primary btn-xs'>go</a>");
        $("div.dataTables_filter input").off();
        $("div.dataTables_filter input").on('keydown', function(e) {
            if (e.which == 13) {
                oTable.search( $("div.dataTables_filter input").val()).draw();
            }
        });
        $("#mySearch").on('click', function(e) {
                oTable.search( $("div.dataTables_filter input").val()).draw();
        });
    

    // tab confirm
    $('#saveCampaign').on('click', function(){
        
        let search_value = $('input[type=search]').val(),
            campaign_name = $('#campaign_name').val(),
            csrf_token = $('#csrf_token').val(),
            globalTemplateID = $('select[name=template_name]').val(),
            globalSenderID = $('select[name=sender_name]').val(),
            recipientsQuantity = $('#recipient_qty').val(),
            id_campaign = $('#id_campaign').val(),
            recipient_status = $('#recipient_status').val()
        ;
        
        if (campaign_name != '' && globalTemplateID != '' && globalSenderID != '' && recipientsQuantity != '0') {
            $(this).html('Preparing campaign, please wait...').addClass('disabled');
            $('.site_title i').addClass('fa-spin');
            $.ajax({
                method: 'POST',
                url: 'index.php?manage=statistics&data=modify&action=insert',
                data : {
                    name : campaign_name,
                    id_template : globalTemplateID,
                    id_sender : globalSenderID,
                    csrf_token : csrf_token,
                    search : search_value,
                    recipient_qty : recipientsQuantity,
                    id_campaign: id_campaign,
                    recipient_status: recipient_status
                }
            }).done(function(){
                location.href = 'index.php?manage=campaign&action=waiting';
            });
        }
    });

    $('#campaignForm').on('submit', function(e){
        return false;
    });

});


