<?php

defined('_MAILING') or die('Restricted access');

if (DEMO_MODE) {
    header("Location: index.php?manage=campaign&action=waiting");
    exit();
}

$app->checkToken();

/**
 * get new campaign data
 */
$name = $app->clearSQL($_POST['name']);
$search = $app->clearSQL($_POST['search']);
$id_template = (int)($_POST['id_template']);
$id_sender = (int)($_POST['id_sender']);
$recipient_qty = (int)($_POST['recipient_qty']);
$old_id_campaign = (int)($_POST['id_campaign']);
$recipient_status = (int)($_POST['recipient_status']);
$status = '0';

/*
    status
    0 - prepared
    1 - sent
    2 - opened
    3 - unsubscribed

*/

/*all data*/
if ($recipient_status == '0') {
    $recipient_status_sql = "";
}
/*sent*/
if ($recipient_status == '1') {
    $recipient_status_sql = " AND crc.status = '1' ";
}
/*opened (and unsubscribed)*/
if ($recipient_status == '2') {
    $recipient_status_sql = " AND crc.status IN('2', '3') ";
}
/*not opened yet*/
if ($recipient_status == '3') {
    $recipient_status_sql = " AND crc.status = '3' ";
}


/**
 * insert new campaign to db
 */
$sql = "
    INSERT INTO ".PREF."_campaign  (
        name, 
        recipient_qty,  
        id_template,  
        id_sender,
        status
    ) VALUES (
        :name,
        :recipient_qty,
        :id_template,
        :id_sender,
        :status
    )
";
$stmt = $db->prepare($sql);              
$stmt->bindParam(':name', $name, PDO::PARAM_STR);
$stmt->bindParam(':recipient_qty', $recipient_qty, PDO::PARAM_STR);
$stmt->bindParam(':id_template', $id_template, PDO::PARAM_STR);
$stmt->bindParam(':id_sender', $id_sender, PDO::PARAM_STR);
$stmt->bindParam(':status', $status, PDO::PARAM_STR);
$stmt->execute(); 


/**
 * get id of inserted campaign
 */
$id_campaign = $db->lastInsertId();


/**
 * prepare filter for sql for recipients id based on posted search field
 */
if ($search != '') {
    $filtr = '';
    $fraza_array = explode(" ", $search);
    foreach ($fraza_array as $val) {
        $filtr .= " AND (person LIKE '%".$val."%' OR software LIKE '%".$val."%' OR geodata LIKE '%".$val."%') ";
    }
} else {
    $filtr = "";
}

/**
 * get all selected recipients id
 */
$sql = "
    SELECT id FROM (
        SELECT
            r.id,
            CONCAT (
                r.person, ' ', r.email, ' ', r.comment, ' ', r.website
            ) AS person,
            g.user_agent AS software,
            CONCAT (
                g.country_code, ' ', g.city, ' ', g.region, ' ', g.country_name, ' ', g.region_name
            ) AS geodata
        FROM 
            ".PREF."_campaign_rec_conn AS crc
            LEFT JOIN ".PREF."_recipient AS r ON(r.id = crc.id_recipient)
            LEFT JOIN ".PREF."_geolocation AS g ON(g.ip_receiver = crc.ip_receiver)
        WHERE 1
            AND crc.id_campaign = '".$old_id_campaign."'
            AND r.id is not null
            ".$recipient_status_sql."
    ) as a
    WHERE 1 ".$filtr."
";
$result = $db->query($sql);

/**
 * prepare campaign connections
 */
foreach ($result as $row) {
    
    $sql = "
        INSERT INTO ".PREF."_campaign_rec_conn (
            id_campaign,
            id_recipient
        ) VALUES (
            :id_campaign,
            :id_recipient
        )
    ";
    $stmt = $db->prepare($sql);              
    $stmt->bindParam(':id_campaign', $id_campaign, PDO::PARAM_STR);    
    $stmt->bindParam(':id_recipient', $row['id'], PDO::PARAM_STR);
    $stmt->execute(); 
}

header("Location: index.php?manage=campaign&action=waiting");
