"use strict";

$(document).ready(function () {
    
    $('#smtpTest').on('show.bs.modal', function (event) {
        $('#response').css({display: 'none'}).html('');
        var button = $(event.relatedTarget);
        var username = button.data('username');
        var smtpid = button.data('smtpid');
        var modal = $(this);
        modal.find('.smtpid').val(smtpid);
        modal.find('.username').val(username);
    });
    
    $('#smtpDelete').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var smtp = button.data('smtp');
        var smtpid = button.data('smtpid');
        var modal = $(this);
        modal.find('.smtpid').val(smtpid);
        modal.find('.smtp').val(smtp);
    });
        
    $.fn.dataTableExt.oStdClasses.sPageButton = "btn btn-default";
    
    $('#tags').DataTable({
        stateSave: true,
        language: dataTableTranslation
    });
    
    
    $('#testConnection').on('click', function(event){
        var username = $('input[name=username]').val();
        var smtpid = $('input[name=smtpid]').val();
        var debug_level = $('#debug_level').val();
        var csrf_token = $('input[name=csrf_token]').val();
        var button = $(this);
        
        button.addClass('disabled').removeClass('btn-primary').addClass('btn-warning');
        
        $('#response').css({display: 'none'}).html('');
        event.preventDefault();
        
        $.ajax({
            type : 'POST',
            url : 'index.php?manage=smtp&adata=modify&action=test',
            async: true,
            data: {
                username : username,
                smtpid : smtpid,
                debug_level : debug_level,
                adata : '1',
                csrf_token : csrf_token
            },
            success: function(response) {
                $('#response').css({display: 'block'}).html(response);
                button.removeClass('disabled').addClass('btn-primary').removeClass('btn-warning');
            }
        });
        
    });

});