<?php

defined('_MAILING') or die('Restricted access');

if (DEMO_MODE) {
    echo SMTP_TEST_OK;
    exit();
}

$app->checkToken();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once file_exists('php/class/PHPMailer/src/Exception.php') ? 'php/class/PHPMailer/src/Exception.php' : '../../../../php/class/PHPMailer/src/Exception.php';
require_once file_exists('php/class/PHPMailer/src/PHPMailer.php') ? 'php/class/PHPMailer/src/PHPMailer.php' : '../../../../php/class/PHPMailer/src/PHPMailer.php';
require_once file_exists('php/class/PHPMailer/src/SMTP.php') ? 'php/class/PHPMailer/src/SMTP.php' : '../../../../php/class/PHPMailer/src/SMTP.php';

// use SMTP server
if ((int)(Settings::$useSMTP)) {
    
    // get SMTP server id
    $smtpid = (int)($_POST['smtpid']);
    $debug_level = (int)($_POST['debug_level']);
    $sendTo = $_POST['username'];
    
    $stmt = $db->prepare(" select * from ".PREF."_smtp where id=? ");
    $stmt->bindParam(1, $smtpid, PDO::PARAM_INT);
    $stmt->execute();
    $row = $stmt->fetchAll();
    @$data = $row[0];

    $host = $data['host'];
    $name = $data['name'];
    $smtpauth = $data['smtpauth'] == '1' ? true : false ;
    $username = $data['username']; // bounce to
    $login = $data['login'];
    $password = $data['password'];
    $replytomail = $data['replytomail'];
    $replytoname = $data['replytoname'];
    $smtpsecure = $data['smtpsecure'];
    $port = $data['port'];
    $forcesmtp = $data['forcesmtp'] == '1' ? true : false ;
    $verifypeer = $data['verifypeer'] == '1' ? true : false ;
    
    //use DKIM
    $usedkim = $data['usedkim'];
    $DKIM_domain = $data['dkim_domain'];
    $DKIM_private = $data['dkim_private'];
    $DKIM_selector = $data['dkim_selector'];
    $DKIM_passphrase = $data['dkim_passphrase'];
    $DKIM_identity = $data['dkim_identity'];
    
    //require 'php/PHPMailerAutoload.php';

    $mail = new PHPMailer;
    $mail->CharSet = "UTF-8";
    $mail->SMTPDebug = $debug_level;
    if (!$verifypeer) {
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            )
        );
    }
    if ($forcesmtp) {
        $mail->isSMTP();
    }
    $mail->Host = $host;
    $mail->Port = $port;
    $mail->SMTPAuth = $smtpauth;
    $mail->Username = $login;
    $mail->Password = $password;
    
    $mail->SMTPSecure = $smtpsecure;
    $mail->setFrom($username); // bounce to
    
    $mail->ClearReplyTos();
    $mail->AddReplyTo($replytomail, $replytoname);
    
    $mail->FromName = "Emailer";
    $mail->addAddress($sendTo);
    
    if ($usedkim == '1') {
        $mail->DKIM_domain = $DKIM_domain;
        $mail->DKIM_private = $DKIM_private;
        $mail->DKIM_selector = $DKIM_selector;
        $mail->DKIM_passphrase = $DKIM_passphrase;
        $mail->DKIM_identity = $DKIM_identity;
    }
    
    // just in case can be added
    //$mail->addCC($sendTo);
    
    $mail->isHTML(true);
    $mail->Subject = SMTP_TEST_TXT_TITLE.' ('.$name.')';
    $mail->Body    = "<!DOCTYPE html><html><head><title></title></head><body>".SMTP_TEST_TXT_MESSAGE."</body>";
    $mail->AltBody = SMTP_TEST_TXT_MESSAGE;
    
    if (! $mail->send()) {
        echo SMTP_TEST_ERROR . $mail->ErrorInfo;
    } else {
        echo SMTP_TEST_OK;
    }
} else {
    echo SMTP_BEFORE_USE;
}
