<?php

defined('_MAILING') or die('Restricted access');

$languageFiles = Array();

if (!$scanned_folder = @scandir($_SERVER['DOCUMENT_ROOT'] . dirname($_SERVER['SCRIPT_NAME']) . '/languages/')) {
    echo "Failed to open this directory. ".error_get_last(); 
} else {
    foreach ($scanned_folder as $file) {
        $fileName = explode(".", $file);
        if ($fileName[1] == 'php') {
            array_push($languageFiles, $fileName[0]);
        }
    }
}

$optionLanguages = '';

foreach ($languageFiles as $currLang) {
    if (DEMO_MODE && isset($_SESSION['language'])) {
        $selected = $_SESSION['language'] == $currLang ? ' selected="selected"' : '';
    } else {
        $selected = Settings::$systemLanguage == $currLang ? ' selected="selected"' : '';
    }
    
    $optionLanguages .= "<option value='".$currLang."'".$selected.">".$currLang."</option>";
}

?>
<input type="hidden" id="mode" value="<?php echo DEMO_MODE ? 1 : 0; ?>">

<div class="page-title">
    <div class="title_left">
        <h3><?php echo MENU_SYSTEM_CONFIGURATION;?> <small>(<?php echo MENU_SYSTEM_PARAMS;?>)</small></h3>
    </div>
</div>
<div class="clearfix"></div>

<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2><?php echo SETTINGS_GLOBAL;?></h2>
                <button id="resetStorage" class="btn btn-primary btn-xs pull-right">reset localstorage</button>
                <div class="clearfix"></div>
            </div>
            <div class="x_content">
                <form class="form-horizontal" method="post" action="index.php?manage=settings&action=system.update">
                    <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
                    <?php 
                    if (! $fileSettingsWittable) {
                    ?>
                        <div class="alert alert-danger" role="alert">
                            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                            <span class="sr-only">Error:</span>
                            <b>WARNING!</b> file '<b>configuration.php</b>' is not writtable. Settings will not be saved. Change file permissions before saving.
                        </div>
                    <?php
                    }
                    ?>
                    <input type="hidden" name="adata" value="1">
                    
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="ecode">Envato purchase code</label>
                        <div class="col-sm-6">
                            <input 
                                type="text" 
                                class="form-control" 
                                id="ecode" 
                                name="ecode" 
                                placeholder="" 
                                value="<?php echo Settings::$ecode; ?>" 
                                required
                            >
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label for-checkbox" for="useHTTPS"><?php echo HTTPS_USAGE;?></label>
                        <div class="col-sm-8">
                          <input 
                            type="checkbox" 
                            class="form-control flat" 
                            id="useHTTPS" 
                            name="useHTTPS"
                            value="1"
                            <?php echo Settings::$useHTTPS == '1' ? 'checked="checked"' : ''; ?>
                            >&nbsp;<?php echo HTTPS_USAGE_INFO;?>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="smtp"><?php echo SENDING_METHOD;?></label>
                        <div class="col-sm-6">
                            <div class="radio">
                                <label class="myRedirect">
                                <div class="iradio_flat-green">
                                    <input value="1" type="radio" name="smtp" class="flat" <?php echo Settings::$useSMTP == '1' ? 'checked="checked"' : ''; ?>><ins class="iCheck-helper"></ins>
                                </div> <?php echo SMTP_SERVER_DESCRIPTION;?>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="smtp"></label>
                        <div class="col-sm-4">
                            <div class="radio">
                                <label class="myRedirect">
                                <div class="iradio_flat-green">
                                    <input value="0" type="radio" name="smtp" class="flat" <?php echo Settings::$useSMTP == '0' ? 'checked="checked"' : ''; ?>><ins class="iCheck-helper"></ins></div> PHP mail(). <?php echo SETTINGS_LIMIT;?>
                                </label>
                            </div>
                        </div>
                        <div class="col-sm-2">
                          <input 
                            type="number"
                            class="form-control" 
                            id="limit" 
                            name="limit" 
                            placeholder="<?php echo SETTINGS_LIMIT_PLACEHOLDER;?>" 
                            value="<?php echo Settings::$limitPerHour; ?>" 
                            required
                            >
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="editor"><?php echo TEMPLATES_TITLE_EDIT;?></label>
                        <div class="col-sm-6">
                            <select name="editor" class="form-control" id="editor">
                                <option value="textarea" <?php echo Settings::$systemEditor == 'textare' ? ' selected="selected"' : ''; ?>>Textarea</option>
                                <option value="tinymce" <?php echo Settings::$systemEditor == 'tinymce' ? ' selected="selected"' : ''; ?>>TinyMCE</option>
                                <option value="codemirror" <?php echo Settings::$systemEditor == 'codemirror' ? ' selected="selected"' : ''; ?>>CodeMirror</option>
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="language"><?php echo SETTINGS_LANG;?></label>
                        <div class="col-sm-6">
                            <select name="language" class="form-control" id="language">
                                <?php echo $optionLanguages;?>
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label for-checkbox" for="tracking"><?php echo SETTINGS_TRACKING;?></label>
                        <div class="col-sm-8">
                          <input 
                            type="checkbox" 
                            class="form-control flat" 
                            id="tracking" 
                            name="tracking"
                            <?php echo Settings::$enableTracking == '1' ? 'checked="checked"' : ''; ?>
                            >&nbsp;<?php echo SETTINGS_TRACK_INFO;?>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label for-checkbox" for="deleteunsubscribed"><?php echo SETTINGS_UNSUBSCRIBED;?></label>
                        <div class="col-sm-8">
                          <input 
                            type="checkbox" 
                            class="form-control flat" 
                            id="deleteunsubscribed" 
                            name="deleteunsubscribed"
                            <?php echo Settings::$deleteUnsubscribed == '1' ? 'checked="checked"' : ''; ?>
                            >&nbsp;<?php echo SETTINGS_UNS_INFO;?>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="googleMapsApiKey"><?php echo SETTINGS_API_LABEL;?></label>
                        <div class="col-sm-6">
                          <input 
                            type="text" 
                            class="form-control" 
                            id="googleMapsApiKey" 
                            name="googleMapsApiKey"
                            value = "<?php echo DEMO_MODE ? "" : Settings::$googleMapsApiKey; ?>"
                            placeholder="<?php echo SETTINGS_API_PLACEHOLDER;?>"
                            >
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">&nbsp;</label>
                        <div class="col-sm-6">
                            <p><a class="btn btn-success" href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank"><?php echo SETTINGS_API_LINK_INFO;?></a></p>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="ipstackGeoApiKey"><?php echo SETTINGS_API_GEO_LABEL;?></label>
                        <div class="col-sm-6">
                          <input 
                            type="text" 
                            class="form-control" 
                            id="ipstackGeoApiKey" 
                            name="ipstackGeoApiKey"
                            value = "<?php echo DEMO_MODE ? "" : Settings::$ipstackGeoApiKey; ?>"
                            placeholder="<?php echo SETTINGS_API_GEO_PLACEHOLDER;?>"
                            >
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">&nbsp;</label>
                        <div class="col-sm-6">
                            <p><a class="btn btn-success" href="https://ipstack.com/signup/free" target="_blank"><?php echo SETTINGS_API_GEO_LINK_INFO;?></a></p>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="thechecker">thechecker.co -> emailable.com<br>API key</label>
                        <div class="col-sm-6">
                          <input 
                            type="text" 
                            class="form-control" 
                            id="thechecker" 
                            name="thechecker"
                            value = "<?php echo DEMO_MODE ? "" : Settings::$thechecker; ?>"
                            placeholder=""
                            >
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">&nbsp;</label>
                        <div class="col-sm-6">
                            <p><a class="btn btn-success" href="https://thechecker.co/?coupon=AFDBE9" target="_blank"><?php echo SETTINGS_API_THECHECKER;?></a></p>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="adminMail"><?php echo SETTINGS_ADMIN_MAIL;?></label>
                        <div class="col-sm-6">
                          <input 
                            type="email" 
                            class="form-control" 
                            id="adminMail" 
                            name="adminMail"
                            value = "<?php echo Settings::$adminMail; ?>"
                            placeholder="<?php echo SETTINGS_ADMIN_MAIL_PLACEHOLDER;?>"
                            >
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="phpTimeOutLimit"><?php echo SETTINGS_PHP_TIMEOUT;?></label>
                        <div class="col-sm-6">
                          <input 
                            type="number" 
                            class="form-control" 
                            id="phpTimeOutLimit" 
                            name="phpTimeOutLimit"
                            value = "<?php echo Settings::$phpTimeOutLimit; ?>"
                            >
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="charset"><?php echo SETTINGS_CHARSET;?></label>
                        <div class="col-sm-6">
                            <select name="charset" class="form-control" id="charset">
                                <option value="big5"     <?php echo Settings::$charset == "big5"     ? ' selected="selected"' : ''; ?>>Big5 Traditional Chinese</option>
                                <option value="dec8"     <?php echo Settings::$charset == "dec8"     ? ' selected="selected"' : ''; ?>>DEC West European</option>
                                <option value="cp850"    <?php echo Settings::$charset == "cp850"    ? ' selected="selected"' : ''; ?>>DOS West European</option>
                                <option value="hp8"      <?php echo Settings::$charset == "hp8"      ? ' selected="selected"' : ''; ?>>HP West European</option>
                                <option value="koi8r"    <?php echo Settings::$charset == "koi8r"    ? ' selected="selected"' : ''; ?>>KOI8-R Relcom Russian</option>
                                <option value="latin1"   <?php echo Settings::$charset == "latin1"   ? ' selected="selected"' : ''; ?>>cp1252 West European</option>
                                <option value="latin2"   <?php echo Settings::$charset == "latin2"   ? ' selected="selected"' : ''; ?>>ISO 8859-2 Central European</option>
                                <option value="swe7"     <?php echo Settings::$charset == "swe7"     ? ' selected="selected"' : ''; ?>>7bit Swedish</option>
                                <option value="ascii"    <?php echo Settings::$charset == "ascii"    ? ' selected="selected"' : ''; ?>>US ASCII</option>
                                <option value="ujis"     <?php echo Settings::$charset == "ujis"     ? ' selected="selected"' : ''; ?>>EUC-JP Japanese</option>
                                <option value="sjis"     <?php echo Settings::$charset == "sjis"     ? ' selected="selected"' : ''; ?>>Shift-JIS Japanese</option>
                                <option value="hebrew"   <?php echo Settings::$charset == "hebrew"   ? ' selected="selected"' : ''; ?>>ISO 8859-8 Hebrew</option>
                                <option value="tis620"   <?php echo Settings::$charset == "tis620"   ? ' selected="selected"' : ''; ?>>TIS620 Thai</option>
                                <option value="euckr"    <?php echo Settings::$charset == "euckr"    ? ' selected="selected"' : ''; ?>>EUC-KR Korean</option>
                                <option value="koi8u"    <?php echo Settings::$charset == "koi8u"    ? ' selected="selected"' : ''; ?>>KOI8-U Ukrainian</option>
                                <option value="gb2312"   <?php echo Settings::$charset == "gb2312"   ? ' selected="selected"' : ''; ?>>GB2312 Simplified Chinese</option>
                                <option value="greek"    <?php echo Settings::$charset == "greek"    ? ' selected="selected"' : ''; ?>>ISO 8859-7 Greek</option>
                                <option value="cp1250"   <?php echo Settings::$charset == "cp1250"   ? ' selected="selected"' : ''; ?>>Windows Central European</option>
                                <option value="gbk"      <?php echo Settings::$charset == "gbk"      ? ' selected="selected"' : ''; ?>>GBK Simplified Chinese</option>
                                <option value="latin5"   <?php echo Settings::$charset == "latin5"   ? ' selected="selected"' : ''; ?>>ISO 8859-9 Turkish</option>
                                <option value="armscii8" <?php echo Settings::$charset == "armscii8" ? ' selected="selected"' : ''; ?>>ARMSCII-8 Armenian</option>
                                <option value="utf8"     <?php echo Settings::$charset == "utf8"     ? ' selected="selected"' : ''; ?>>UTF-8 Unicode</option>
                                <option value="ucs2"     <?php echo Settings::$charset == "ucs2"     ? ' selected="selected"' : ''; ?>>UCS-2 Unicode</option>
                                <option value="cp866"    <?php echo Settings::$charset == "cp866"    ? ' selected="selected"' : ''; ?>>DOS Russian</option>
                                <option value="keybcs2"  <?php echo Settings::$charset == "keybcs2"  ? ' selected="selected"' : ''; ?>>DOS Kamenicky Czech-Slovak</option>
                                <option value="macce"    <?php echo Settings::$charset == "macce"    ? ' selected="selected"' : ''; ?>>Mac Central European</option>
                                <option value="macroman" <?php echo Settings::$charset == "macroman" ? ' selected="selected"' : ''; ?>>Mac West European</option>
                                <option value="cp852"    <?php echo Settings::$charset == "cp852"    ? ' selected="selected"' : ''; ?>>DOS Central European</option>
                                <option value="latin7"   <?php echo Settings::$charset == "latin7"   ? ' selected="selected"' : ''; ?>>ISO 8859-13 Baltic</option>
                                <option value="utf8mb4"  <?php echo Settings::$charset == "utf8mb4"  ? ' selected="selected"' : ''; ?>>UTF-8 Unicode</option>
                                <option value="cp1251"   <?php echo Settings::$charset == "cp1251"   ? ' selected="selected"' : ''; ?>>Windows Cyrillic</option>
                                <option value="utf16"    <?php echo Settings::$charset == "utf16"    ? ' selected="selected"' : ''; ?>>UTF-16 Unicode</option>
                                <option value="cp1256"   <?php echo Settings::$charset == "cp1256"   ? ' selected="selected"' : ''; ?>>Windows Arabic</option>
                                <option value="cp1257"   <?php echo Settings::$charset == "cp1257"   ? ' selected="selected"' : ''; ?>>Windows Baltic</option>
                                <option value="utf32"    <?php echo Settings::$charset == "utf32"    ? ' selected="selected"' : ''; ?>>UTF-32 Unicode</option>
                                <option value="binary"   <?php echo Settings::$charset == "binary"   ? ' selected="selected"' : ''; ?>>Binary pseudo charset</option>
                                <option value="geostd8"  <?php echo Settings::$charset == "geostd8"  ? ' selected="selected"' : ''; ?>>GEOSTD8 Georgian</option>
                                <option value="cp932"    <?php echo Settings::$charset == "cp932"    ? ' selected="selected"' : ''; ?>>SJIS for Windows Japanese</option>
                                <option value="eucjpms"  <?php echo Settings::$charset == "eucjpms"  ? ' selected="selected"' : ''; ?>>UJIS for Windows Japanese</option>
                            </select>
                        </div>
                    </div>
                    <hr>
                    
                    <div class="form-group">
                        <div class="col-sm-offset-2 col-sm-2">
                          <button type="submit" class="btn btn-primary"><?php echo SAVE; ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="components/settings/view.settings.system.js"></script>
