<?php

defined('_MAILING') or die('Restricted access');

$tags_option = '';

$stmt = $db->prepare("
    SELECT
        r.id,
        r.person,
        r.email,
        r.comment,
        r.txt_only,
        r.website,
        r.f01,
        r.f02,
        r.f03,
        (
            SELECT group_concat(rc.id_tag SEPARATOR ', ') AS tags 
            FROM ".PREF."_recipient_tag_conn AS rc 
            where r.id=rc.id_recipient
        ) AS tag
    FROM 
        ".PREF."_recipient AS r
    WHERE
        r.id=? 
");
$id = (int)($_GET['id']);
$stmt->bindParam(1, $id, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();

// in case you want to edit not existent data
if (! @$data = $row[0]){
    echo DATA_ERROR;
    exit();
}

$p_tag = explode(',',$data['tag']);

$tags = $db->query(" SELECT * FROM ".PREF."_recipient_tag ORDER BY name ASC ");
foreach ($tags as $tag) {
    $checked = in_array($tag['id'],$p_tag) ? " checked='checked' " : "" ;
    $tags_option .= "<div class='checkbox'><label><input class='flat' type='checkbox' name='tags[]' value='".$tag['id']."' ".$checked.">&nbsp;".$tag['name']."</label></div>";
}

$recipientname = $data['person'];
$recipientmail = $data['email'];
$recipientcomment = $data['comment'];
$recipientwebsite = $data['website'];
$recipientf01 = $data['f01'];
$recipientf02 = $data['f02'];
$recipientf03 = $data['f03'];
$textonly = $data['txt_only'] != '0' ? 'checked="checked"' : '' ;

?>
<div class="page-title">
    <div class="title_left">
        <h3><?php echo EMAIL_ADRESSES;?> <small>(<?php echo RECIPIENT_EDIT;?>)</small></h3>
    </div>
</div>
<div class="clearfix"></div>

<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2><?php echo RECIPIENT_DETAILS_EDIT;?></h2>
                <div class="clearfix"></div>
            </div>
            <div class="x_content">
                <form class="form-horizontal" action="index.php?manage=recipient&data=modify&action=update" method="post">
                    <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
                    <input type="hidden" name="id" value="<?php echo $id;?>">
                    <div class="form-group">
                    <label for="recipientname" class="col-sm-2 control-label"><?php echo RECIPIENT_NAME;?></label>
                        <div class="col-sm-5">
                            <input 
                                type="text" 
                                class="form-control" 
                                id="recipientname" 
                                name="recipientname" 
                                value="<?php echo $recipientname;?>" 
                                placeholder="<?php echo RECIPIENT_NAME_PLACEHOLDER;?>">
                        </div>
                    </div>
                    <div class="form-group">
                    <label for="recipientmail" class="col-sm-2 control-label"><?php echo RECIPIENT_MAIL;?>*</label>
                        <div class="col-sm-5">
                            <input 
                                type="email" 
                                class="form-control" 
                                id="recipientmail" 
                                name="recipientmail" 
                                value="<?php echo $recipientmail;?>" 
                                placeholder="<?php echo RECIPIENT_MAIL_PLACEHOLDER;?>" 
                                required>
                        </div>
                    </div>
                    <div class="form-group">
                    <div class="col-sm-offset-2 col-sm-10">
                      <div class="checkbox">
                        <label>
                          <input class="flat" type="checkbox" name="textonly" <?php echo $textonly;?>> <?php echo RECIPIENT_ONLY_TXT;?>
                        </label>
                      </div>
                    </div>
                    </div>
                    <div class="form-group">
                    <label for="recipientcomment" class="col-sm-2 control-label"><?php echo RECIPIENT_DESCRIPTION;?></label>
                        <div class="col-sm-5">
                            <input 
                                type="text" 
                                class="form-control" 
                                id="recipientcomment" 
                                name="recipientcomment" 
                                value="<?php echo $recipientcomment;?>" 
                                placeholder="<?php echo RECIPIENT_DESCRIPTION_PLACEHOLDER;?>" 
                                >
                        </div>
                    </div>
                    <div class="form-group">
                    <label for="recipientwebsite" class="col-sm-2 control-label">f0</label>
                        <div class="col-sm-5">
                            <input 
                                type="text" 
                                class="form-control" 
                                id="recipientwebsite" 
                                name="recipientwebsite" 
                                value="<?php echo $recipientwebsite;?>" 
                                placeholder="field0" 
                                >
                        </div>
                    </div>
                    <div class="form-group">
                    <label for="recipientf01" class="col-sm-2 control-label">f1</label>
                        <div class="col-sm-5">
                            <input 
                                type="text" 
                                class="form-control" 
                                id="recipientf01" 
                                name="recipientf01" 
                                value="<?php echo $recipientf01;?>" 
                                placeholder="field1" 
                                >
                        </div>
                    </div>
                    <div class="form-group">
                    <label for="recipientf02" class="col-sm-2 control-label">f2</label>
                        <div class="col-sm-5">
                            <input 
                                type="text" 
                                class="form-control" 
                                id="recipientf02" 
                                name="recipientf02" 
                                value="<?php echo $recipientf02;?>" 
                                placeholder="field2" 
                                >
                        </div>
                    </div>
                    <div class="form-group">
                    <label for="recipientf03" class="col-sm-2 control-label">f3</label>
                        <div class="col-sm-5">
                            <input 
                                type="text" 
                                class="form-control" 
                                id="recipientf03" 
                                name="recipientf03" 
                                value="<?php echo $recipientf03;?>" 
                                placeholder="field3" 
                                >
                        </div>
                    </div>
                    <div class="form-group">
                    <label for="tagsname" class="col-sm-2 control-label"><?php echo TAGS;?></label>
                        <div class="col-sm-5">
                            <?php echo $tags_option; ?>
                        </div>
                    </div>
                    <p>&nbsp;</p>
                    <div class="form-group">
                        <div class="col-sm-offset-2 col-sm-1">
                            <a href="index.php?manage=recipient&action=list" type="button" class="btn btn-success"><i class="fa fa-frown-o"></i> <?php echo CANCEL;?></a>
                        </div>
                        <div class="col-sm-offset-3 col-sm-1">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-download"></i> <?php echo SAVE;?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<p>&nbsp;</p>
