"use strict";

$(document).ready(function () {
    
    $('#tagDelete').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var tagname = button.data('tagname');
        var tagid = button.data('tagid');
        var modal = $(this);
        modal.find('.tagid').val(tagid);
        modal.find('.tagname').val(tagname);
    });
        
    $.fn.dataTableExt.oStdClasses.sPageButton = "btn btn-default";
    
    $('#tags').DataTable({
        stateSave: true,
        language: dataTableTranslation
    });
    
    $('#verifyDelete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget);
        var verifyname = button.data('verifyname');
        var verifyid = button.data('verifyid');
        var id = button.data('id');
        var modal = $(this);
        modal.find('.verifyname').val(verifyname);
        modal.find('.verifyid').val(verifyid);
        modal.find('.id').val(id);
    });
    
    verifyBulkCheckng();
    verifyDownload();
    
});

function verifyBulkCheckng() {
    $('.verifyStatusChecking').off();
    $('.verifyStatusChecking').on('click', function() {
        var button = $(this),
            id = button.attr('data-id');
        
        button.addClass('disabled').removeClass('btn-info').addClass('btn-dark').html(lang_v_working);
        $('#m_' + id).html('');
        $('#p_' + id).html('');
        $.ajax({
            method: 'POST',
            url: 'index.php?manage=recipient&data=modify&action=verify_bulk_status_checking',
            data : {
                csrf_token: $('input[name=csrf_token]').val(),
                id: id
            },
            statusCode: {
                200: function(res) {
                    
                    var obj = JSON.parse(res);
                    $('#m_' + id).html(obj.message);
                    $('#p_' + id).html(obj.percentage);
                    if (obj.percentage == '100') {
                        $('#vd_' + id).removeClass('disabled');
                    }
                    
                    alert(obj.message);
                    //alert(res);
                },
                400: function() {
                    //alert(res);
                },
                404: function() {
                    alert( "page not found" );
                }
            }
        }).done(function(res){
            button.removeClass('disabled').addClass('btn-info').removeClass('btn-dark').html(lang_button_check_status);
        });
    });
}

function verifyDownload() {
    $('.verifyDownload').off();
    $('.verifyDownload').on('click', function() {
        var button = $(this),
            id = button.attr('data-id');
        
        button.addClass('disabled').removeClass('btn-success').addClass('btn-dark').html(lang_v_working);
        $.ajax({
            method: 'POST',
            url: 'index.php?manage=recipient&data=modify&action=verify_download_mails',
            data : {
                csrf_token: $('input[name=csrf_token]').val(),
                id: id
            },
            statusCode: {
                200: function(res) {
                    //var obj = JSON.parse(res);
                    alert(res);
                },
                400: function() {
                    alert(res);
                },
                404: function() {
                    alert( "page not found" );
                }
            }
        }).done(function(res){
            button.removeClass('disabled').addClass('btn-success').removeClass('btn-dark').html(lang_button_down_up);
            alert('emailable.com ' + lang_response + ':\n\n' + res);
        });
    });
}
