<?php

defined('_MAILING') or die('Restricted access');

if (DEMO_MODE) {
    header("Location: index.php?manage=settings&action=system");
    exit();
}

$app->checkToken();

$id = (int)$_POST['id'];


// get data of bulk verification
$stmt = $db->prepare("
    SELECT verify_id FROM  ".PREF."_verify_bulk WHERE id = ?
");
$stmt->bindParam(1, $id, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();

// in case you want to edit not existent data
if (! @$data = $row[0]){
    echo DATA_ERROR;
    exit();
}

$verify_id = $data['verify_id'];

$url = "https://api.thechecker.co/v2/verifications/".$verify_id."?api_key=".Settings::$thechecker;

$ch = curl_init();
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_URL,$url);
$result = curl_exec($ch);
curl_close($ch);

$json = json_decode($result, true);

//print_r($result);

//$info = $json['result'];

if (isset($json['message'])) {
    $verify_message = $json['message'];
    
    // update data
    $sql = "
        UPDATE 
            ".PREF."_verify_bulk
        SET 
            verify_message      = :verify_message,
            percentage          = NULL
        WHERE 
            verify_id           = :verify_id
    ";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':verify_message',     $verify_message, PDO::PARAM_STR);
    $stmt->bindParam(':verify_id',          $verify_id, PDO::PARAM_STR);
    
    if (!$stmt->execute()) {
        $verify_message = $stmt->errorInfo();
    }
    
    echo json_encode(Array(
        'message' => $verify_message,
        'percentage' => ''
    ));
    
    exit();
}

$verify_message = "Verified ".intval($json['status']['percentage'])." %";


// get data from thechecker.co
$unavailable_smtp   = $json['status']['unavailable_smtp'];
$timeout            = $json['status']['timeout'];
$invalid_domain     = $json['status']['invalid_domain'];
$invalid_email      = $json['status']['invalid_email'];
$no_connect         = $json['status']['no_connect'];
$rejected_email     = $json['status']['rejected_email'];
$disposable         = $json['status']['disposable'];
$accept_all         = $json['status']['accept_all'];
$role               = $json['status']['role'];
$accepted_email     = '';//$json['status']['accepted_email'];
$unknown            = $json['status']['unknown'];
$undeliverable      = $json['status']['undeliverable'];
$risky              = $json['status']['risky'];
$deliverable        = $json['status']['deliverable'];
$verified           = $json['status']['verified'];
$total              = $json['status']['total'];
$percentage         = $json['status']['percentage'];
$paid               = '';//$json['paid'];

if ($json['status']['percentage'] == '100') {
    $verify_message = 'Verified';
}
    

try {
    // update data
    $sql = "
        UPDATE 
            ".PREF."_verify_bulk
        SET 
            verify_message      = :verify_message,
            unavailable_smtp    = :unavailable_smtp,
            timeout             = :timeout,
            invalid_domain      = :invalid_domain,
            invalid_email       = :invalid_email,
            no_connect          = :no_connect,
            rejected_email      = :rejected_email,
            disposable          = :disposable,
            accept_all          = :accept_all,
            role                = :role,
            accepted_email      = :accepted_email,
            unknown             = :unknown,
            undeliverable       = :undeliverable,
            risky               = :risky,
            deliverable         = :deliverable,
            verified            = :verified,
            total               = :total,
            percentage          = :percentage,
            paid                = :paid
        WHERE 
            verify_id           = :verify_id
    ";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':verify_message',     $verify_message, PDO::PARAM_STR);
    $stmt->bindParam(':unavailable_smtp',   $unavailable_smtp, PDO::PARAM_INT);
    $stmt->bindParam(':timeout',            $timeout, PDO::PARAM_INT);
    $stmt->bindParam(':invalid_domain',     $invalid_domain, PDO::PARAM_INT);
    $stmt->bindParam(':invalid_email',      $invalid_email, PDO::PARAM_INT);
    $stmt->bindParam(':no_connect',         $no_connect, PDO::PARAM_INT);
    $stmt->bindParam(':rejected_email',     $rejected_email, PDO::PARAM_INT);
    $stmt->bindParam(':disposable',         $disposable, PDO::PARAM_INT);
    $stmt->bindParam(':accept_all',         $accept_all, PDO::PARAM_INT);
    $stmt->bindParam(':role',               $role, PDO::PARAM_INT);
    $stmt->bindParam(':accepted_email',     $accepted_email, PDO::PARAM_INT);
    $stmt->bindParam(':unknown',            $unknown, PDO::PARAM_INT);
    $stmt->bindParam(':undeliverable',      $undeliverable, PDO::PARAM_INT);
    $stmt->bindParam(':risky',              $risky, PDO::PARAM_INT);
    $stmt->bindParam(':deliverable',        $deliverable, PDO::PARAM_INT);
    $stmt->bindParam(':verified',           $verified, PDO::PARAM_INT);
    $stmt->bindParam(':total',              $total, PDO::PARAM_INT);
    $stmt->bindParam(':percentage',         $percentage, PDO::PARAM_INT);
    $stmt->bindParam(':paid',               $paid, PDO::PARAM_INT);
    $stmt->bindParam(':verify_id',          $verify_id, PDO::PARAM_STR);
    
    if (!$stmt->execute()) {
        $verify_message = 'Exception -> '.$stmt->errorInfo();
    }
    
}
catch(Exception $e) {
    echo json_encode(Array(
        'message' => 'Exception -> '.$e->getMessage(),
        'percentage' => ''
    ));
    exit();
}

    echo json_encode(Array(
        'message' => $verify_message,
        'percentage' => intval($json['status']['percentage'])
    ));





