<?php

defined('_MAILING') or die('Restricted access');

if (DEMO_MODE) {
    header("Location: index.php?manage=recipient&action=list");
    exit();
}

$app->checkToken();

$person = $_POST['recipientname'];
$email = $_POST['recipientmail'];
$comment = $_POST['recipientcomment'];
$website = $_POST['recipientwebsite'];
$f01 = $_POST['recipientf01'];
$f02 = $_POST['recipientf02'];
$f03 = $_POST['recipientf03'];
$txt_only = isset($_POST['textonly']) ? 1 : 0 ;
$tags = isset($_POST['tags']) ? $_POST['tags'] : 0 ;

$sql = "
    INSERT INTO ".PREF."_recipient (
        person,
        email,
        comment,
        website,
        f01,
        f02,
        f03,
        txt_only
    ) VALUES (
        :person,
        :email,
        :comment,
        :website,
        :f01,
        :f02,
        :f03,
        :txt_only
    )
";
$stmt = $db->prepare($sql);
$stmt->bindParam(':person', $person, PDO::PARAM_STR);
$stmt->bindParam(':email', $email, PDO::PARAM_STR);
$stmt->bindParam(':comment', $comment, PDO::PARAM_STR);
$stmt->bindParam(':website', $website, PDO::PARAM_STR);
$stmt->bindParam(':f01', $f01, PDO::PARAM_STR);
$stmt->bindParam(':f02', $f02, PDO::PARAM_STR);
$stmt->bindParam(':f03', $f03, PDO::PARAM_STR);
$stmt->bindParam(':txt_only', $txt_only, PDO::PARAM_STR);
$stmt->execute(); 

$id = $db->lastInsertId();

if ($tags != 0) {
    foreach ($tags as $tag) {
        $sql = "
        INSERT INTO ".PREF."_recipient_tag_conn (
            id_recipient,
            id_tag
        ) VALUES (
            :id_recipient,
            :id_tag
        )
        ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_recipient', $id, PDO::PARAM_STR);    
        $stmt->bindParam(':id_tag', $tag, PDO::PARAM_STR);
        $stmt->execute();
    }
}

header("Location: index.php?manage=recipient&action=list");
