"use strict";

$(document).ready(function () {
    
    $('#actionDelete').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var fieldname = button.data('fieldname');
        var fieldid = button.data('fieldid');
        var modal = $(this);
        modal.find('.fieldid').val(fieldid);
        modal.find('.fieldname').val(fieldname);
    });
    $('#importRecipients').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var fieldname = button.data('fieldname');
        var bridge_id = button.data('bridge_id');
        var modal = $(this);
        modal.find('.bridge_id').val(bridge_id);
        modal.find('.fieldname').val(fieldname);
        $('#importLog').html('');
    });
        
    $.fn.dataTableExt.oStdClasses.sPageButton = "btn btn-default";
    
    $('#fields').DataTable({
        stateSave: true,
        language: dataTableTranslation
    });

    $('#startImportRecipients').on('click', function(event) {
        event.preventDefault();
        importRecipients();
    });

});

function importRecipients() {
    var bridge_id = $('input#bridge_id').val(),
        csrf_token = $('input[name="csrf_token"]').val();
        
    showImportLog('<span class="red">' + lang_bridge_import_in_progress + '</span>');
        
    if (bridge_id == '') {
        showImportLog('form bridge_id not present...');
        return;
    }
    
    $.ajax({
        method: 'POST',
        url: 'index.php?manage=import_bridge&data=modify&action=import_recipients',
        data : {
            csrf_token : csrf_token,
            bridge_id : bridge_id
        }
    }).done(function(data){
        showImportLog(data);
    });
    
}

function showImportLog(txt) {
    $('#importLog').html(txt);
}