<?php

defined('_MAILING') or die('Restricted access');

// build search query for db2
$import_cols = $source_col_rec_mail;
$import_cols .= $source_col_rec_name != '' ? ', '.$source_col_rec_name : '';
$import_cols .= $source_col_rec_desc != '' ? ', '.$source_col_rec_desc : '';
$import_cols .= $source_col_rec_website != '' ? ', '.$source_col_rec_website : '';
$import_cols .= $source_col_rec_f01 != '' ? ', '.$source_col_rec_f01 : '';
$import_cols .= $source_col_rec_f02 != '' ? ', '.$source_col_rec_f02 : '';
$import_cols .= $source_col_rec_f03 != '' ? ', '.$source_col_rec_f03 : '';

$insert_qty = 0;
$update_qty = 0;
$errors_qty = 0;

$result2 = $db2->query(" SELECT ".$import_cols." FROM ".$source_table_name." ");
foreach ($result2 as $row) {
    if ($row[$source_col_rec_mail] != '') {
        $updated = false;
        $update_tags = false;
        $new_name = isset($row[$source_col_rec_name]) ? $row[$source_col_rec_name] : '';
        $new_name = ltrim($new_name.' '.$additional_name);
        $new_desc = isset($row[$source_col_rec_desc]) ? $row[$source_col_rec_desc] : '';
        $new_desc = ltrim($new_desc.' '.$additional_desc);
        $new_website = isset($row[$source_col_rec_website]) ? $row[$source_col_rec_website] : '';
        $new_website = ltrim($new_website);
        $new_f01 = isset($row[$source_col_rec_f01]) ? $row[$source_col_rec_f01] : '';
        $new_f01 = ltrim($new_f01);
        $new_f02 = isset($row[$source_col_rec_f02]) ? $row[$source_col_rec_f02] : '';
        $new_f02 = ltrim($new_f02);
        $new_f03 = isset($row[$source_col_rec_f03]) ? $row[$source_col_rec_f03] : '';
        $new_f03 = ltrim($new_f03);
        
        // get existing recipient id or set it to 0 if not exists
        $stmt = $db->query(" SELECT id from ".PREF."_recipient WHERE email = '".$row[$source_col_rec_mail]."' ");
        $stmt->execute();
        $recipient = $stmt->fetchAll();
        $id_recipient = count($recipient) ? (int) $recipient[0]['id'] : 0;    
        
        // option update enabled
        if ($destination_update) {
            $date_modify = date("Y-m-d H:i:s", time());
            
            // if recipient exists, update
            if ($id_recipient) {
                $sql = "
                    UPDATE 
                        ".PREF."_recipient
                    SET 
                        date_modify = :date_modify, 
                        person = :person,
                        comment = :comment,
                        website = :website,
                        f01 = :f01,
                        f02 = :f02,
                        f03 = :f03
                    WHERE 
                        id = :id
                ";
                $stmt = $db->prepare($sql);
                $stmt->bindParam(':date_modify', $date_modify, PDO::PARAM_STR);
                $stmt->bindParam(':person', $new_name, PDO::PARAM_STR);
                $stmt->bindParam(':comment', $new_desc, PDO::PARAM_STR);
                $stmt->bindParam(':website', $new_website, PDO::PARAM_STR);
                $stmt->bindParam(':f01', $new_f01, PDO::PARAM_STR);
                $stmt->bindParam(':f02', $new_f02, PDO::PARAM_STR);
                $stmt->bindParam(':f03', $new_f03, PDO::PARAM_STR);
                $stmt->bindParam(':id', $id_recipient, PDO::PARAM_STR);
                $stmt->execute();
                $updated = true;
                $update_tags = true;
                $update_qty ++;
            }
        }
        
        // not updated and not exists, just insert new recipient
        if (! $updated && ! $id_recipient) {
            $sql = "
                INSERT INTO ".PREF."_recipient (
                    person, 
                    email,  
                    comment,
                    website,
                    f01,
                    f02,
                    f03
                ) VALUES (
                    :person,
                    :email,
                    :comment,
                    :website,
                    :f01,
                    :f02,
                    :f03
                )
            ";
            $stmt = $db->prepare($sql);
            $stmt->bindParam(':person', $new_name, PDO::PARAM_STR);
            $stmt->bindParam(':email', $row[$source_col_rec_mail], PDO::PARAM_STR);
            $stmt->bindParam(':comment', $new_desc, PDO::PARAM_STR);
            $stmt->bindParam(':website', $new_website, PDO::PARAM_STR);
            $stmt->bindParam(':f01', $new_f01, PDO::PARAM_STR);
            $stmt->bindParam(':f02', $new_f02, PDO::PARAM_STR);
            $stmt->bindParam(':f03', $new_f03, PDO::PARAM_STR);
            $stmt->execute();
            $id_recipient = $db->lastInsertId();
            $update_tags = true;
            $insert_qty++;
        }
        
        // update tags if neccesary
        if ($update_tags && count($tagsArr)) {
            // update tags
            $sql = "DELETE FROM ".PREF."_recipient_tag_conn WHERE id_recipient =  :id";
            $stmt = $db->prepare($sql);
            $stmt->bindParam(':id', $id_recipient, PDO::PARAM_INT);   
            $stmt->execute();
            foreach ($tagsArr as $tagId) {
                $sql = "
                    INSERT INTO ".PREF."_recipient_tag_conn (
                        id_recipient,
                        id_tag
                    ) VALUES (
                        :id_recipient,
                        :id_tag
                    )
                ";
                $stmt = $db->prepare($sql);
                $stmt->bindParam(':id_recipient', $id_recipient, PDO::PARAM_STR);    
                $stmt->bindParam(':id_tag', $tagId, PDO::PARAM_STR);
                $stmt->execute();
            }
        }
    } else {
        $errors_qty++;
    }
}

echo '<span class="green">'.BRIDGE_IMPORT_OK1.$update_qty.' '.BRIDGE_IMPORT_OK2.$insert_qty.' '.ERRORS.':'.$errors_qty.'</span><br>';
