<?php

defined('_MAILING') or die('Restricted access');

// to avoid CSRF hacking
$app->checkToken();

if (DEMO_MODE) {
    echo "<span class='red'>import not possible in demo mode</span>";
    exit();
}

// get source db2 params
$id = (int)($_POST['bridge_id']);
$stmt = $db->prepare(" select * from ".PREF."_recipient_bridge where id=? ");
$stmt->bindParam(1, $id, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();
$data = $row[0];
$bridge_description = $data['bridge_description'];
$bridge_db_host = $data['bridge_db_host'];
$bridge_db_user = $data['bridge_db_user'];
$bridge_db_password = $data['bridge_db_password'];
$bridge_db_name = $data['bridge_db_name'];
$source_table_name = $data['source_table_name'];
$source_col_rec_name = $data['source_col_rec_name'];
$source_col_rec_mail = $data['source_col_rec_mail'];
$source_col_rec_desc = $data['source_col_rec_desc'];
$source_col_rec_website = $data['source_col_rec_website'];
$source_col_rec_f01 = $data['source_col_rec_f01'];
$source_col_rec_f02 = $data['source_col_rec_f02'];
$source_col_rec_f03 = $data['source_col_rec_f03'];

// import configuration
$additional_name = $data['additional_name'];
$additional_desc = $data['additional_desc'];
$tagsArr = explode(',',$data['option_tags']);
$destination_update = $data['option_override'] == '1' ? true : false;

// check source params, in case of wrong settings and setup db2 connector
include('components/import_bridge/action.import_bridge.check_source.php');

// check source host for query optimization
if (Settings::$dbHost == $bridge_db_host) {
    include('components/import_bridge/action.import_bridge.import_recipients_1_host.php');
} else {
    include('components/import_bridge/action.import_bridge.import_recipients_2_hosts.php');
}
