"use strict";

$(document).ready(function() {
    var q1 = $('#campaign_qty').attr('data-campaign_create_month_qty').split(','),
        lineChartData = {
            labels: [lang_jan, lang_feb, lang_mar, lang_apr, lang_may, lang_jun, lang_jul, lang_aug, lang_sep, lang_oct, lang_nov, lang_dec],
            datasets: [
                {
                    label: lang_d_prepared_overall,
                    fillColor: "rgba(38, 185, 154, 0.31)",
                    color: "red",
                    strokeColor: "rgba(38, 185, 154, 0.5)",
                    pointColor: "rgba(38, 185, 154, 0.5)",
                    pointStrokeColor: "#fff",
                    pointHighlightFill: "#fff",
                    pointHighlightStroke: "rgba(220,220,220,1)",
                    data: $('#campaign_qty').attr('data-campaign_create_month_qty').split(',')
                },
                {
                    label: lang_d_sent_overall,
                    fillColor: "rgba(3, 88, 106, 0.3)",
                    strokeColor: "rgba(3, 88, 106, 0.70)",
                    pointColor: "rgba(3, 88, 106, 0.70)",
                    pointStrokeColor: "#fff",
                    pointHighlightFill: "#fff",
                    pointHighlightStroke: "rgba(151,187,205,1)",
                    data: $('#campaign_qty').attr('data-campaign_start_month_qty').split(',')
                }
            ]
        },
        myLineChart = new Chart(document.getElementById("canvas000").getContext("2d")).Line(lineChartData, {
            responsive: true,
            tooltipFillColor: "rgba(51, 51, 51, 0.55)",
            legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].strokeColor%>\">&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;<%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>"
        });
        
    document.getElementById("legendDiv").innerHTML = myLineChart.generateLegend();
    
    if ($(".progress .progress-bar")[0]) {
        $('.progress .progress-bar').progressbar();
    }
});
