<?php

defined('_MAILING') or die('Restricted access');

$i = 0;
$recipient_head = '';
$recipient_body = '';
$result = $db->query("
    SELECT
        r.id,
        c.name,
        r.person,
        r.email,
        (
            SELECT group_concat(rt.name SEPARATOR ', ') AS tags 
            FROM ".PREF."_recipient_tag_conn AS rc 
            LEFT JOIN ".PREF."_recipient_tag AS rt ON(rc.id_tag=rt.id)
            WHERE r.id=rc.id_recipient
        ) AS tag
    FROM 
        ".PREF."_campaign_rec_conn AS crc
    LEFT JOIN ".PREF."_campaign AS c ON(c.id = crc.id_campaign) 
    LEFT JOIN ".PREF."_recipient AS r ON(r.id = crc.id_recipient) 
    WHERE
        crc.status = '3'
");
$recipient_head .= "<tr><th>#</th><th>".CAMPAIGN_NAME."</th><th>".PERSON."</th><th>".TAGS."</th><th>".EMAIL."</th><th></th></tr>";
foreach ($result as $row) {
    if ($row['email'] != '') {
        $i++;
        $recipient_body .= "
        <tr>
            <td>".$i."</td>
            <td><a href='index.php?manage=recipient&action=edit&id=".$row['id']."'>".$row['name']."</a></td>
            <td><a href='index.php?manage=recipient&action=edit&id=".$row['id']."'>".$row['person']."</a></td>
            <td><a href='index.php?manage=recipient&action=edit&id=".$row['id']."'>".$row['tag']."</a></td>
            <td><a href='index.php?manage=recipient&action=edit&id=".$row['id']."'>".$row['email']."</a></td>
            <td>
                <button type='button' class='btn btn-danger btn-xs pull-right' data-toggle='modal' data-target='#recipientDelete' data-recipientid='".$row['id']."' data-recipientname='".$row['person']."' data-recipientemail='".$row['email']."'>".DELETE."</button>
                <a class='btn btn-warning btn-xs pull-right' href='index.php?manage=recipient&action=edit&id=".$row['id']."' >".EDIT."</a>
            </td>
        </tr>";
    }
}
?>

<div class="modal fade" id="recipientDelete" tabindex="-1" role="dialog" aria-labelledby="recipientDeleteLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="recipientDeleteLabel"><?php echo DELETING; ?></h4>
            </div>
            <form action="index.php?manage=recipient&data=modify&action=delete" method="post">
                <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
                <div class="modal-body">
                    <input type="hidden" name="backtounsubscribers" class="" value="unsubscribers">
                    <input type="hidden" name="recipientid" class="recipientid" value="">
                    <div class="form-group">
                        <label for="recipientname" class="control-label"><?php echo DELETING_CONFIRM_QUESTION; ?></label>
                        <input type="text" class="form-control recipientname" disabled>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CANCEL;?></button>
                    <button type="submit" class="btn btn-danger"><?php echo DELETE;?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="unsubscribersDelete" tabindex="-1" role="dialog" aria-labelledby="unsubscribersDeleteLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="unsubscribersDeleteLabel"><?php echo DELETING; ?></h4>
          </div>
            <form action="index.php?manage=campaign&data=modify&action=unsubscribersdelete" method="post">
                <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
                <div class="modal-body">
                    <input type="hidden" name="tagid" class="tagid" value="">
                    <div class="form-group">
                        <label for="tagname" class="control-label"><?php echo DELETING_CONFIRM_QUESTION; ?></label>
                        <p><?php echo CAMPAIGN_UNSUBSCRIBERS_DELETE_INFO; ?></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CANCEL;?></button>
                    <button type="submit" class="btn btn-danger"><?php echo DELETE;?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="page-title">
    <div class="title_left">
        <h3><?php echo MENU_UNSUBSCRIBED;?> <small>(<?php echo MENU_UNSUBSCRIBED_LIST;?>)</small></h3>
    </div>
</div>
<div class="clearfix"></div>

<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2><?php echo RECIPIENT_DB;?></h2>
                <div class="clearfix"></div>
            </div>
            <div class="x_content">
                <table class="table table-striped responsive-utilities jambo_table" id="waitingCampaign">
                    <thead>
                        <?php echo $recipient_head; ?>
                    </thead>
                    <tbody>
                        <?php echo $recipient_body; ?>
                    </tbody>
                </table>
            </div>
            <button type='button' class='btn btn-primary' data-toggle='modal' data-target='#unsubscribersDelete'><?php echo CAMPAIGN_UNSUBSCRIBERS_DELETE; ?></button>
        </div>
    </div>
</div>
<p>&nbsp;</p>

<script src="components/campaign/view.campaign.unsubscribed.js"></script>
