<?php

defined('_MAILING') or die('Restricted access');

// background params checking
$lack_of_config = '';
ignore_user_abort(true);
$backgroundOk = false;
if ( ini_get('ignore_user_abort') == '1' && (int)ini_get('max_execution_time') == (int)(Settings::$phpTimeOutLimit) ) {
    $backgroundOk = true;
} else {
    $lack_of_config .= '<p><b>WARNING!</b> <br>settings blocked by hosting admin, background sending may not work correctly</p>';
    if ( ini_get('ignore_user_abort') == '1' ) {
        $lack_of_config .= '<p><b>ignore_user_abort</b> should be set to <b>true</b></p>';
    }
    if ( (int)ini_get('max_execution_time') == (int)(Settings::$phpTimeOutLimit) ) {
        $lack_of_config .= '<p><b>max_execution_time</b> should be <b>'.(Settings::$phpTimeOutLimit).'</b></p>';
    }
}

$id_campaign = (int)($_GET['campaign']);
$campaign_name = '';
$recipient_qty = 0;
$remaining_qty = 0;
$template_name = '';
$sender_name = '';
$in_progress = false;

$stmt = $db->prepare("
    SELECT
        c.id,
        c.name,
        c.recipient_qty,
        status,
        date_create,
        (
            SELECT concat(t.name, ' ', t.subject) FROM ".PREF."_template AS t WHERE t.id = c.id_template
        ) AS templatename,
        (
            SELECT concat(s.name, ' ', s.email) FROM ".PREF."_sender AS s WHERE s.id = c.id_sender
        ) AS sendername
    FROM 
        ".PREF."_campaign AS c
    WHERE
        id=?
");
$stmt->bindParam(1, $id_campaign, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();
$data = $row[0];

$campaign_name = $data['name'];
$recipient_qty = (int)$data['recipient_qty'];
$template_name = $data['templatename'];
$sender_name = $data['sendername'];

$stmt = $db->prepare("
    SELECT
        count(id_campaign) AS qty
    FROM 
        ".PREF."_campaign_rec_conn
    WHERE
        id_campaign=? AND status = '0'
");
$stmt->bindParam(1, $id_campaign, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();
$remaining_qty = (int)$row[0]['qty'];


// when SMTP choosen
if ((int)(Settings::$useSMTP)) {
    $result = $db->query(" SELECT * FROM ".PREF."_smtp ");
    $smtp_select = "<option></option>";
    $smtp_list = '';
    $smtp_qty = 0;
    foreach ($result as $row) {
        $smtp_select .= "<option value='".$row['id'].":".$row['maxlimit']."'>".$row['name']."&nbsp;-&nbsp;".$row['host']." [limit:".$row['maxlimit']."/".HOUR."]</option>";
        $smtp_list .= "<p><input class='form-control flat' type='checkbox' name='smtp_arr[]' value='".$row['id']."' data-limit='".$row['maxlimit']."'> - ".$row['name']."&nbsp;-&nbsp;".$row['host']." [limit:".$row['maxlimit']."/".HOUR."]</p>";
    }
}

if ($recipient_qty - $remaining_qty) {
    $in_progress = true;
}

?>
<div class="page-title">
    <div class="title_left">
        <h3><?php echo MENU_CAMPAIGNS;?> <small>(<?php echo CAMPAIGN_CURRENT_STATUS;?>)</small></h3>
    </div>
</div>
<div class="clearfix"></div>

<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2><?php echo CAMPAIGN_SENT_NOW;?></h2>
                <div class="clearfix"></div>
            </div>
            <div class="x_content">
                <div class="form-horizontal" id="campaignForm">
                    <input type="hidden" name="csrf_token" id="csrf_token" value="<?php echo $app->getToken();?>">
                    <div class="form-group">
                        <label for="campaign_name" class="col-sm-2 control-label"><?php echo CAMPAIGN_NAME;?></label>
                            <div class="col-sm-6">
                            <input type="text" class="form-control" value="<?php echo $campaign_name; ?>" disabled>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="recipient_qty" class="col-sm-2 control-label"><?php echo CAMPAIGN_RECIPIENT_QTY;?></label>
                        <div class="col-sm-2">
                            <input type="text" class="form-control" value="<?php echo $recipient_qty; ?>" disabled>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="template_name" class="col-sm-2 control-label"><?php echo CAMPAIGN_TEMPLATE_NAME;?></label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" value="<?php echo $template_name; ?>" disabled>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="sender_name" class="col-sm-2 control-label"><?php echo CAMPAIGN_SENDER;?></label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" value="<?php echo $sender_name; ?>" disabled>
                        </div>
                    </div>
                    <?php
                    if ((int)(Settings::$useSMTP)) { ?>
                        
                        <div class="form-group" id="multi_smtp_group">
                            <label class="col-sm-2 control-label" for="multi_smtp"><?php echo MULTI_SMTP;?></label>
                            <div class="col-sm-6 padding-top-checkbox">
                                <div class="pull-left col-sm-1">
                                  <input 
                                    type="checkbox" 
                                    class="form-control flat" 
                                    id="multi_smtp" 
                                    name="multi_smtp"
                                    value="1"
                                    >
                                </div>
                                <div class="pull-right col-sm-11">
                                  <?php echo MULTI_CHECK_DESC; ?>
                                </div>
                            </div>
                        </div>

                        <div id="single" class="form-group">
                            <label for="smtpid" class="col-sm-2 control-label"><?php echo CAMPAIGN_SMTP;?></label>
                            <div class="col-sm-6">
                                <select class="form-control" name="smtpid" required>
                                    <?php echo $smtp_select; ?>
                                </select>
                            </div>
                        </div>
                        <div id="multi" class="form-group hidden">
                            <label for="smtp_arr" class="col-sm-2 control-label"><?php echo MULTI_CHOOSE;?></label>
                            <div class="col-sm-6">
                                <ul>
                                    <?php echo $smtp_list; ?>
                                </ul>
                            </div>
                        </div>
                        <?php
                    }
                    ?>

                    <?php
                    if ($in_progress) {
                    ?>
                        <div class="form-group">
                            <label for="sender_name" class="col-sm-2 control-label"><?php echo CAMPAIGN_LEFT;?></label>
                            <div class="col-sm-2">
                                <input type="text" class="form-control" value="<?php echo $remaining_qty; ?>" disabled>
                            </div>
                        </div>
                    <?php
                    }
                    ?>
                    <div class="form-group">
                        <label for="sender_name" class="col-sm-2 control-label">&nbsp;</label>
                        <div class="col-sm-6">
                            <div class="progress">
                                <div 
                                    class="progress-bar active" 
                                    role="progressbar" 
                                    aria-valuenow="0" 
                                    aria-valuemin="0" 
                                    aria-valuemax="100"
                                >
                                0%
                                </div>
                            </div>
                            <div id="progres_info" class="alert-dark"></div>
                            <div id="go_to_list"><a class="btn btn-primary" href="index.php?manage=campaign&action=proceed"><?php echo MENU_CAMPAIGNS_IN_PROGRESS;?></a></div>
                        </div>
                    </div>
                    <hr>
                        <div class="form-group" id="backgroundinfo">
                            <label class="col-sm-2 control-label" for="backgroundProcess"><?php echo CAMPAIGN_BG_PROCESS;?></label>
                            <div class="col-sm-6 padding-top-checkbox">
                                <div class="pull-left col-sm-1">
                                  <input 
                                    type="checkbox" 
                                    class="form-control flat" 
                                    id="backgroundProcess" 
                                    name="backgroundProcess"
                                    value="1"
                                    >
                                </div>
                                <div class="pull-right col-sm-11">
                                  <?php echo CAMPAIGN_BG_PROCESS_INFO;?>
                                </div>
                            </div>
                        </div>
                    <?php 
                        if (! $backgroundOk) { 
                            echo $lack_of_config;
                        } 
                    ?>
                    <div class="form-group" id="admininfo">
                        <label class="col-sm-2 control-label" for="adminNotification"><?php echo CAMPAIGN_WHEN_FINISH;?></label>
                        <div class="col-sm-6">
                            <div class="pull-left col-sm-1 padding-top-checkbox">
                              <input 
                                type="checkbox" 
                                class="form-control flat" 
                                id="adminNotification" 
                                name="adminNotification"
                                value="1"
                                >&nbsp;
                            </div>
                            <div class="pull-right col-sm-11">
                              <input 
                                type="email"
                                class="form-control"
                                id="emailToAdmin" 
                                name="emailToAdmin" 
                                value="<?php echo Settings::$adminMail;?>"
                                placeholder="<?php echo CAMPAIGN_EMAIL_FIN_PLACEHOLDER;?>"
                                >
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label for="confirm" class="col-sm-2 control-label"></label>
                        <div class="col-sm-6">
                            <button
                                id="startCampaign"
                                type="submit"
                                class="btn btn-primary"
                                data-use_smtp = "<?php echo Settings::$useSMTP; ?>"
                                data-limit_per_hour = "<?php echo Settings::$limitPerHour;?>"
                                data-remaining_qty = "<?php echo $remaining_qty;?>"
                            >
                                <?php echo $in_progress ? CAMPAIGN_RESUME_BUTTON : CAMPAIGN_SENT_BUTTON;?>
                            </button>
                            <a href="index.php?manage=campaign&action=start&campaign=<?php echo $id_campaign; ?>" class="btn btn-default" id="stopCampaign"><?php echo CANCEL;?></a>
                            <a href="index.php?manage=campaign&action=sent" class="btn btn-primary" id="listCampaign" ><?php echo CLOSE;?></a>
                        </div>
                    </div>
                    <p>&nbsp;</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="components/campaign/view.campaign.start.js"></script>
