<?php

defined('_MAILING') or die('Restricted access');

$i = 0;
$recipient_head = '';
$recipient_body = '';
$campaign_list = '';

$result = $db->query("
    SELECT
        c.id,
        c.name,
        c.recipient_qty,
        c.id_template,
        c.status,
        c.date_create,
        c.date_start,
        (
            SELECT count(crc.id_recipient) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id and crc.status IN('2','3')
        ) AS receivers,
        (
            SELECT count(crc.id_recipient) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id and crc.bounced='1'
        ) AS bounced,
        (
            SELECT count(crc.clicked) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id and crc.clicked != '0'
        ) AS clicked,
        (
            SELECT sum(crc.clicked) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id
        ) AS clicks,
        (
            SELECT count(crc.id_recipient) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id and crc.status='3'
        ) AS unsubscribers,
        (
            SELECT count(crc.id_recipient) FROM ".PREF."_campaign_rec_conn AS crc WHERE crc.id_campaign = c.id and crc.status='4'
        ) AS errors,
        (
            SELECT t.thumb_filename FROM ".PREF."_template t WHERE t.id = c.id_template
        ) AS filename
    FROM 
        ".PREF."_campaign AS c
    ORDER BY id DESC
");

$recipient_head .= "<tr><th>#</th><th>".CAMPAIGN_NAME."</th><th>".CAMPAIGN_RECIPIENT_QTY."</th><th></th><th></th><th>".D_EMAIL_EFFICIENCY."</th><th>Bounced</th><th>Clicked</th><th>".D_EMAIL_UNSUBSCIBERS."</th></tr>";

foreach ($result as $row) {
    $i++;
    
    $thumb_filename = $row['filename'] !='' ? $row['filename'] : 'no-picture.png';
    
    $number = ((int)($row['receivers']) / (int)($row['recipient_qty'])) * 100;
    $number = number_format($number, 2, ',', '');
    
    $number2 = ((int)($row['bounced']) / (int)($row['recipient_qty'])) * 100;
    $number2 = number_format($number2, 2, ',', '');
    
    $number3 = ((int)($row['clicked']) / (int)($row['recipient_qty'])) * 100;
    $number3 = number_format($number3, 2, ',', '');
    
    $number4 = ((int)($row['unsubscribers']) / (int)($row['recipient_qty'])) * 100;
    $number4 = number_format($number4, 2, ',', '');
 /*
 * 0 - prepared
 * 1 - during AJAX sending
 * 2 - finished
 * 3 - during background sending
 * 4 - stopped
 * 5 - during cron sending
 */
 switch ($row['status']) {
    case '0':
        $statusTxt = '<em class="blue">'.C_PREPARED.' </em>';
        break;
    case '1':
        $statusTxt = '<em class="red">'.C_AJAX_PROGRESS.' </em>';
        break;
    case '2':
        $statusTxt = '<em class="green">'.C_FINISHED.' </em>';
        break;
    case '3':
        $statusTxt = '<em class="red">'.C_BG_PROGRESS.' </em>';
        break;
    case '4':
        $statusTxt = '<em class="purple">'.C_PAUSED.' </em>';
        break;
    case '5':
        $statusTxt = '<em class="red">'.C_CRON.' </em>';
        break;
 }
    
    $recipient_body .= "<tr><td>".$i."</td><td>".$row['name']."</td><td>".$row['recipient_qty']."</td><td>".$row['date_create']."</td><td>".$row['date_start']."</td>
    <td>".$number."
    <div class='x_content'>
        <div class='pie_div'>
            <span class='chart' data-percent='86'>
                <span class='percent'></span>
            </span>
        </div>
        <div class='pie_bg'>
            <canvas id='canvas_doughnut' height='130'></canvas>
        </div>
    </div>
    </td>
    <td>".$number2."</td><td>".$number3."</td><td>".$row['unsubscribers']."<button type='button' class='btn btn-danger btn-xs pull-right' data-toggle='modal' data-target='#campaignDelete' data-campaignname='".$row['name']."' data-campaignid='".$row['id']."' >".DELETE."</button></td></tr>";
    
    
    $date_create = substr($row['date_create'], 0, 10);
    //$date_create = strtotime($date_create);
    //$date_create = date('d-m-Y',$date_create);
    
    $date_start = substr($row['date_start'], 0, 10);
    //$date_start = strtotime($date_start);
    //$date_start = date('d-m-Y', $date_start);
    
    
    $campaign_list .= '
      <div>
        <div class="x_panel">
          <div class="x_title bg-custom">
            <h2><b>'.$row['name'].'</b> - '.$statusTxt.'</h2>
            <ul class="nav navbar-right panel_toolbox">
              <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a></li>
              <li><a class="close-link"><i class="fa fa-close"></i></a></li>
            </ul>
            <div class="clearfix"></div>
          </div>
          <div class="x_content">

            <div class="col-md-2">
                <div>'.CAMPAIGN_RECIPIENT_QTY.': '.$row['recipient_qty'].'</div>
                <div>'.OPENS.': '.$row['receivers'].'</div>
                <div>'.BOUNCED.': '.$row['bounced'].'</div>
                <div>'.UNIQUE_CLICKS.': '.$row['clicked'].'</div>
                <div>'.TOTAL_CLICKS.': '.$row['clicks'].'</div>
                <div>'.D_EMAIL_UNSUBSCIBERS.': '.$row['unsubscribers'].'</div>
                <div>'.CAMPAIGN_CREATED_DATE.': '.$date_create.'</div>
                <div>'.SENT.': '.$date_start.'</div>
                <div>'.ERRORS.': '.$row['errors'].'</div>

            </div>
            <div class="col-md-2">
                <p>'.OPENS.'</p>
                <div class="pie_div">
                    <span class="chart" data-percent="'.$number.'"><span class="percent"></span></span>
                </div>
                <div class="pie_bg">
                    <canvas id="canvas_doughnut" height="130"></canvas>
                </div>
            </div>
            <div class="col-md-2">
                <p>'.BOUNCED.'</p>
                <div class="pie_div">
                    <span class="chart" data-percent="'.$number2.'"><span class="percent"></span></span>
                </div>
                <div class="pie_bg">
                    <canvas id="canvas_doughnut" height="130"></canvas>
                </div>
            </div>
            <div class="col-md-2">
                <p>'.CLICKED.'</p>
                <div class="pie_div">
                    <span class="chart" data-percent="'.$number3.'"><span class="percent"></span></span>
                </div>
                <div class="pie_bg">
                    <canvas id="canvas_doughnut" height="130"></canvas>
                </div>
            </div>
            <div class="col-md-2">
                <p>'.D_EMAIL_UNSUBSCIBERS.'</p>
                <div class="pie_div">
                    <span class="chart" data-percent="'.$number4.'"><span class="percent"></span></span>
                </div>
                <div class="pie_bg">
                    <canvas id="canvas_doughnut" height="130"></canvas>
                </div>
            </div>
            <div class="col-md-2">
                <p><button type="button" class="btn btn-danger btn-xs" data-toggle="modal" data-target="#campaignDelete" data-campaignname="'.$row['name'].'" data-campaignid="'.$row['id'].'" >'.DELETE.'</button></p>
                <p><a class="btn btn-primary btn-xs" href="index.php?manage=statistics&action=details&id='.$row['id'].'" >'.STATISTICS_ADV.'</a></p>
                <img src="uploads/'.$thumb_filename.'">
            </div>

          </div>
        </div>
      </div>
    
    ';
    

    
}

?>
<div class="modal fade" id="campaignDelete" tabindex="-1" role="dialog" aria-labelledby="campaignDeleteLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="campaignDeleteLabel"><?php echo DELETING; ?></h4>
            </div>
            <form action="index.php?manage=campaign&data=modify&action=delete" method="post">
                <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
                <input type="hidden" name="back_to_sent" value="1">
                <div class="modal-body">
                    <input type="hidden" name="campaignid" class="campaignid" value="">
                    <div class="form-group">
                        <label for="campaignname" class="control-label"><?php echo DELETING_CONFIRM_QUESTION; ?></label>
                        <input type="text" class="form-control campaignname" disabled>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CANCEL;?></button>
                    <button type="submit" class="btn btn-danger"><?php echo DELETE;?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="checkDataIntegrity" tabindex="-1" role="dialog" aria-labelledby="campaignDeleteLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="campaignDeleteLabel"><?php echo DATA_VERIFY; ?></h4>
            </div>
            <form action="index.php?manage=campaign&data=modify&action=checkintegrity" method="post">
                <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="campaignname" class="control-label"><?php echo DATA_VERIFY_QUESTION; ?></label>
                        <p><?php echo DATA_VERIFY_DESCRIPTION; ?></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CANCEL;?></button>
                    <button type="submit" class="btn btn-danger"><?php echo CHECK;?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="page-title">
    <div class="title_left">
        <h3><?php echo MENU_CAMPAIGNS;?> <small>(<?php echo MENU_CAMPAIGNS_SENT;?>)</small></h3>
    </div>
    <button id="checkDataIntegrity" class="btn btn-xs btn-primary pull-right" data-toggle="modal" data-target="#checkDataIntegrity"><?php echo DATA_VERIFY_BUTTON; ?></button>
    <form action="index.php?manage=statistics&action=export" method="post">
        <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
        <input type="hidden" name="adata" value="1">
        <input type="hidden" name="type" value="campaign_list">
        <input type="hidden" name="id_campaign" value="0">
        <input type="submit" value="<?php echo EC_DATA; ?>" class="btn btn-primary btn-xs pull-right">
    </form>
</div>
<div class="clearfix"></div>

<?php
    echo $campaign_list;
?>
<p>&nbsp;</p>

<script src="components/campaign/view.campaign.sent.js"></script>
