<?php

defined('_MAILING') or die('Restricted access');

$i = 0;
$recipient_head = '';
$recipient_body = '';

$result = $db->query("
    SELECT
        c.id,
        c.name,
        c.recipient_qty,
        status,
        date_create,
        (
            SELECT concat(t.name, '<br> ', t.subject) FROM ".PREF."_template AS t WHERE t.id = c.id_template
        ) AS templatename,
        (
            SELECT concat(s.name, '<br>', s.email) FROM ".PREF."_sender AS s WHERE s.id = c.id_sender
        ) AS sendername
    FROM 
        ".PREF."_campaign AS c
    WHERE
        c.status IN('1','3','4')
");

$recipient_head .= "<tr><th>".CAMPAIGN_NAME."</th><th>".CAMPAIGN_RECIPIENT_QTY."</th><th>".PROGRESS."</th><th></th></tr>";

foreach ($result as $row) {
    $i++;
    /**
     * status:
     * 0 - prepared
     * 1 - during AJAX sending
     * 2 - finished
     * 3 - during background sending
     * 4 - stopped
     * 5 - during cron sending
     */
    if ($row['status'] == '1') {
        $buttons = "
        <a class='btn btn-primary btn-xs pull-right' href='index.php?manage=campaign&adata=modify&action=stop.background&campaign=".$row['id']."'>STOP AJAX</a>
        ";
    }
    if ($row['status'] == '3') {
        $buttons = "
        <a class='btn btn-primary btn-xs pull-right' href='index.php?manage=campaign&adata=modify&action=stop.background&campaign=".$row['id']."'>STOP BACKGROUND</a>
        ";
    }
    if ($row['status'] == '4') {
        $buttons = "
        <button type='button' class='btn btn-danger btn-xs pull-right' data-toggle='modal' data-target='#campaignDelete' data-campaignname='".$row['name']."' data-campaignid='".$row['id']."' >".DELETE."</button>
        <a class='btn btn-primary btn-xs pull-right' href='index.php?manage=campaign&action=start&campaign=".$row['id']."'>".RESUME."</a>
        ";
    }
    if ($row['status'] == '5') {
        $buttons = "cron sending";
    }
    
    
    
    $recipient_body .= "<tr><td>".$row['name']."</td><td>".$row['recipient_qty']."</td><td><span class='camp_progress' id='camp_".$row['id']."'>0%</span></td>
    <td id='td_camp_".$row['id']."'>
        ".$buttons."
    </td></tr>";
}

?>
<div class="page-title">
    <div class="title_left">
        <h3><?php echo MENU_CAMPAIGNS;?> <small>(<?php echo MENU_CAMPAIGNS_IN_PROGRESS;?>)</small></h3>
    </div>
</div>
<div class="clearfix"></div>

<div class="modal fade" id="campaignDelete" tabindex="-1" role="dialog" aria-labelledby="campaignDeleteLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="campaignDeleteLabel"><?php echo DELETING; ?></h4>
            </div>
            <form action="index.php?manage=campaign&data=modify&action=delete" method="post">
                <input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
                <div class="modal-body">
                    <input type="hidden" name="campaignid" class="campaignid" value="">
                    <div class="form-group">
                        <label for="campaignname" class="control-label"><?php echo DELETING_CONFIRM_QUESTION; ?></label>
                        <input type="text" class="form-control campaignname" disabled>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo CANCEL;?></button>
                    <button type="submit" class="btn btn-danger"><?php echo DELETE;?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2><?php echo CAMPAIGN_IN_PROGRESS;?></h2>
                <div class="clearfix"></div>
            </div>
            <div class="x_content">
                <table class="table table-striped responsive-utilities jambo_table" id="waitingCampaign">
                    <thead>
                        <?php echo $recipient_head; ?>
                    </thead>
                    <tbody>
                        <?php echo $recipient_body; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<p>&nbsp;</p>

<script src="components/campaign/view.campaign.proceed.js"></script>
