<?php

defined('_MAILING') or die('Restricted access');

$id_campaign = (int)($_GET['campaign']);
$campaign_name = '';
$recipient_qty = 0;
$remaining_qty = 0;
$template_name = '';
$sender_name = '';
$in_progress = false;

$stmt = $db->prepare("
    SELECT
        c.id,
        c.name,
        c.recipient_qty,
        status,
        date_create,
        id_template,
        id_sender
    FROM 
        ".PREF."_campaign AS c
    WHERE
        id=?
");
$stmt->bindParam(1, $id_campaign, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();
$data = $row[0];

$campaign_name = $data['name'];
$recipient_qty = (int)$data['recipient_qty'];
$id_template = $data['id_template'];
$id_sender = $data['id_sender'];



$sender_select = "<option value=''>".CAMPAIGN_FORM_SELECT."</option>";
$template_select = "<option value='' style='background-image:url(uploads/no-picture.png); '>".CAMPAIGN_FORM_SELECT."</option>";

$result = $db->query(" SELECT * FROM ".PREF."_sender ORDER BY name ASC ");
foreach ($result as $row) {
    $selected = ($id_sender == $row['id']) ? "selected='selected'" : "" ;
    $sender_select .= "<option value='".$row['id']."' ".$selected.">".$row['name']." (".$row['email'].")</option>";
}

$result = $db->query(" 
    SELECT t.id, t.name, t.subject, t.thumb_filename AS filename FROM ".PREF."_template AS t
    ORDER BY name ASC 
    ");
foreach ($result as $row) {
    $selected = ($id_template == $row['id']) ? 'selected="selected"' : '' ;
    $template_select .= "<option value='".$row['id']."' ".$selected." style='background-image:url(uploads/".$row['filename']."); '>".$row['name']." (".$row['subject'].")</option>";
}

?>
<div class="page-title">
    <div class="title_left">
        <h3><?php echo MENU_CAMPAIGNS;?> <small>(<?php echo CAMPAIGN_CURRENT_STATUS;?>)</small></h3>
    </div>
</div>
<div class="clearfix"></div>

<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2><?php echo CAMPAIGN_SENT_NOW;?></h2>
                <div class="clearfix"></div>
            </div>
            <div class="x_content">
                <form class="form-horizontal" action="index.php?manage=campaign&data=modify&action=modify.campaign" method="post">
                    <input type="hidden" name="csrf_token" id="csrf_token" value="<?php echo $app->getToken();?>">
                    <input type="hidden" name="id_campaign" id="id_campaign" value="<?php echo $id_campaign;?>">
                    <div class="form-group">
                        <label for="campaign_name" class="col-sm-2 control-label"><?php echo CAMPAIGN_NAME;?></label>
                            <div class="col-sm-5">
                            <input type="text" class="form-control" name="campaign_name" value="<?php echo $campaign_name; ?>">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="recipient_qty" class="col-sm-2 control-label"><?php echo CAMPAIGN_RECIPIENT_QTY;?></label>
                        <div class="col-sm-2">
                            <input type="text" class="form-control" value="<?php echo $recipient_qty; ?>" disabled>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="template_name" class="col-sm-2 control-label"><?php echo CAMPAIGN_TEMPLATE_NAME;?></label>
                        <div class="col-sm-5">
                            <select class="form-control" name="id_template" id="id_template" required>
                                <?php echo $template_select; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="sender_name" class="col-sm-2 control-label"><?php echo CAMPAIGN_SENDER;?></label>
                        <div class="col-sm-5">
                            <select class="form-control" name="id_sender" required>
                                <?php echo $sender_select; ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-sm-offset-2 col-sm-1">
                            <a href="index.php?manage=campaign&action=waiting" type="button" class="btn btn-success"><i class="fa fa-frown-o"></i> <?php echo CANCEL;?></a>
                        </div>
                        <div class="col-sm-offset-3 col-sm-1">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-download"></i> <?php echo SAVE;?></button>
                        </div>
                    </div>
                    <p>&nbsp;</p>
                </form>
            </div>
        </div>
    </div>
</div>

