<?php

defined('_MAILING') or die('Restricted access');

$tags_option = '';

$stmt = $db->prepare("
    SELECT
        r.id,
        r.person,
        r.email,
        r.comment,
        r.txt_only,
        (
            SELECT group_concat(rc.id_tag SEPARATOR ', ') AS tags 
            FROM ".PREF."_recipient_tag_conn AS rc 
            where r.id=rc.id_recipient
        ) AS tag
    FROM ".PREF."_recipient AS r
    WHERE r.id=? 
");
$id = (int)($_GET['id']);
$stmt->bindParam(1, $id, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();
$data = $row[0];

$p_tag = explode(',',$data['tag']);

$tags = $db->query(" SELECT * FROM ".PREF."_recipient_tag ORDER BY name ASC ");
foreach ($tags as $tag) {
    $checked = in_array($tag['id'],$p_tag) ? " checked='checked' " : "" ;
    $tags_option .= "<div class='checkbox'><label><input type='checkbox' name='tags[]' value='".$tag['id']."' ".$checked.">".$tag['name']."</label></div>";
}

$recipientname = $data['person'];
$recipientmail = $data['email'];
$recipientcomment = $data['comment'];
$textonly = $data['txt_only'] != '0' ? 'checked="checked"' : '' ;

?>
<h1><?php echo RECIPIENT_EDIT;?></h1>
<hr/>
<form class="form-horizontal" action="index.php?manage=recipient&data=modify&action=update" method="post">
<input type="hidden" name="csrf_token" value="<?php echo $app->getToken();?>">
 <input type="hidden" name="id" value="<?php echo $id;?>">
  <div class="form-group">
   <label for="recipientname" class="col-sm-2 control-label"><?php echo RECIPIENT_NAME;?></label>
    <div class="col-sm-5">
     <input 
      type="text" 
      class="form-control" 
      id="recipientname" 
      name="recipientname" 
      value="<?php echo $recipientname;?>" 
      placeholder="<?php echo RECIPIENT_NAME_PLACEHOLDER;?>"
     >
    </div>
  </div>
  <div class="form-group">
   <label for="recipientmail" class="col-sm-2 control-label"><?php echo RECIPIENT_MAIL;?>*</label>
    <div class="col-sm-5">
     <input 
      type="email" 
      class="form-control" 
      id="recipientmail" 
      name="recipientmail" 
      value="<?php echo $recipientmail;?>" 
      placeholder="<?php echo RECIPIENT_MAIL_PLACEHOLDER;?>" 
      required
     >
    </div>
  </div>
  <div class="form-group">
   <div class="col-sm-offset-2 col-sm-10">
    <div class="checkbox">
     <label>
      <input type="checkbox" name="textonly" <?php echo $textonly;?>> <?php echo RECIPIENT_ONLY_TXT;?>
     </label>
    </div>
   </div>
  </div>
  <div class="form-group">
   <label for="recipientcomment" class="col-sm-2 control-label"><?php echo RECIPIENT_DESCRIPTION;?></label>
    <div class="col-sm-5">
     <input 
      type="text" 
      class="form-control" 
      id="recipientcomment" 
      name="recipientcomment" 
      value="<?php echo $recipientcomment;?>" 
      placeholder="<?php echo RECIPIENT_DESCRIPTION_PLACEHOLDER;?>" 
     >
    </div>
  </div>
  <div class="form-group">
   <label for="tagsname" class="col-sm-2 control-label"><?php echo TAGS;?></label>
    <div class="col-sm-5">
     <?php echo $tags_option; ?>
    </div>
  </div>
  <div class="form-group">
   <div class="col-sm-offset-2 col-sm-1">
    <button type="submit" class="btn btn-primary"><?php echo SAVE;?></button>
   </div>
   <div class="col-sm-offset-3 col-sm-1">
    <a href="index.php?manage=recipient&action=list" type="button" class="btn btn-default"><?php echo CANCEL;?></a>
   </div>
  </div>
</form>
<p>&nbsp;</p>
