"use strict";

$(document).ready(function(){
        
    $('input.flat').iCheck({
        checkboxClass: 'icheckbox_flat-green',
        radioClass: 'iradio_flat-green',
        fireChange: true
    }).on('ifChanged', function(e) {
        var id = $(e.target).attr('id');
        var isChecked = e.currentTarget.checked;
        
        $(e.target).prop("checked", e.currentTarget.checked === true ? true : false);
        if (isChecked == true) {
            $('#' + id).attr('checked', 'checked');
        } else {
            $('#' + id).removeAttr('checked');
        }
        
        //$('#mojetagi').val($("input.tagi:checked").map(function() {return this.value;}).get().join(","));
        $('#mojetagi').val($('#newtags').val());
        
        if (id == 'OR' || id == 'AND') {
            $('#mojequery').val(id);
        }
    });
    
    $('#newtags').select2({
        width: 'resolve'
    }).on('update change', function() {
        $('#mojetagi').val($('#newtags').val());
    });

    // tab recipients
    $.fn.dataTableExt.oStdClasses.sPageButton = "btn btn-default";
    $('.site_title i').addClass('fa-spin');
    var oTable = $('#campaign').DataTable({
        stateSave: true,
        language: dataTableTranslation,
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "index.php?manage=campaign&data=modify&action=getlist",
            "type": "POST",
            "data": function (d) {
                return $.extend( {}, d, {
                    csrf_token: $("#csrf_token").val(),
                    logic: $("input[name=mojequery]").val(),
                    tags: $('#mojetagi').val()
                }
                );
            }
        },
        "columns": [
            { "data": "id" },
            { "data": "person" },
            { "data": "email" },
            { "data": "tag" },
            { "data": "comment" },
            { "data": "website" }
        ],
        "fnDrawCallback": function( oSettings ) {
          $('#recipient_qty').val( this.fnSettings().fnRecordsDisplay() );
          $('.site_title i').removeClass('fa-spin');
          $('#recordsTotal').html( '(' + oSettings._iRecordsDisplay + '/' + oSettings._iRecordsTotal + ')' );
        }
        
    });
    
        $("div.dataTables_filter").append("<a id='mySearch' class='btn btn-primary btn-xs'>go</a>");
        $("div.dataTables_filter input").off();
        $("div.dataTables_filter input").on('keydown', function(e) {
            if (e.which == 13) {
                oTable.search( $("div.dataTables_filter input").val()).draw();
            }
        });
        $("#mySearch").on('click', function(e) {
                oTable.search( $("div.dataTables_filter input").val()).draw();
        });
    
    

    // tab confirm
    $('#saveCampaign').on('click', function(){
        
        let search_value = $('input[type=search]').val(),
            campaign_name = $('#campaign_name').val(),
            csrf_token = $('#csrf_token').val(),
            globalTemplateID = $('select[name=template_name]').val(),
            globalSenderID = $('select[name=sender_name]').val(),
            recipientsQuantity = $('#recipient_qty').val()
        ;
        
        if (campaign_name != '' && globalTemplateID != '' && globalSenderID != '' && recipientsQuantity != '0') {
            $(this).html('Preparing campaign, please wait...').addClass('disabled');
            $('.site_title i').addClass('fa-spin');
            $.ajax({
                method: 'POST',
                url: 'index.php?manage=campaign&data=modify&action=insert',
                data : {
                    name : campaign_name,
                    id_template : globalTemplateID,
                    id_sender : globalSenderID,
                    csrf_token : csrf_token,
                    search : search_value,
                    recipient_qty : recipientsQuantity,
                    logic: $("input[name=mojequery]").val(),
                    tags: $('#mojetagi').val()
                }
            }).done(function(){
                location.href = 'index.php?manage=campaign&action=waiting';
            });
        }
    });

    $('#campaignForm').on('submit', function(e){
        return false;
    });
    
    $(".resetquery").on('click', function(e) {
        e.preventDefault();
        $.each($('input[type=checkbox]'), function() {
            $(this).prop('checked', false).removeAttr('checked').parent().removeClass('checked');
        });
        $("input[name=mojetagi]").val('');
            
        $("#newtags").val('').trigger('change');
        
        oTable.search('').columns().search('').draw();
    });

});


