<?php

defined('_MAILING') or die('Restricted access');

if (DEMO_MODE) {
    header("Location: index.php?manage=recipient&action=list");
    exit();
}

$app->checkToken();

$date_modify = date("Y-m-d H:i:s", time());
$person = $_POST['recipientname'];
$email = $_POST['recipientmail'];
$comment = $_POST['recipientcomment'];
$txt_only = isset($_POST['textonly']) ? 1 : 0 ;
$id = (int)$_POST['id'];

$sql = "
    UPDATE ".PREF."_recipient SET 
        date_modify = :date_modify, 
        person = :person, 
        email = :email,  
        comment = :comment,  
        txt_only = :txt_only  
    WHERE 
        id = :id
";
$stmt = $db->prepare($sql);
$stmt->bindParam(':date_modify', $date_modify, PDO::PARAM_STR);
$stmt->bindParam(':person', $person, PDO::PARAM_STR);
$stmt->bindParam(':email', $email, PDO::PARAM_STR);
$stmt->bindParam(':comment', $comment, PDO::PARAM_STR);
$stmt->bindParam(':txt_only', $txt_only, PDO::PARAM_STR);
$stmt->bindParam(':id', $id, PDO::PARAM_INT);
$stmt->execute();

$tags = ($_POST['tags']);

$sql = " DELETE FROM ".PREF."_recipient_tag_conn WHERE id_recipient = :id ";
$stmt = $db->prepare($sql);
$stmt->bindParam(':id', $id, PDO::PARAM_INT);   
$stmt->execute();

foreach ($tags as $tag) {
    $sql = "
        INSERT INTO ".PREF."_recipient_tag_conn (
            id_recipient,
            id_tag
        ) VALUES (
            :id_recipient,
            :id_tag
        )
    ";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':id_recipient', $id, PDO::PARAM_STR);
    $stmt->bindParam(':id_tag', $tag, PDO::PARAM_STR);
    $stmt->execute();
}

header("Location: index.php?manage=recipient&action=list");
