<?php

defined('_MAILING') or die('Restricted access');

$recipientmail = isset($_GET['m']) ? $_GET['m'] : '';
$recipientname = isset($_GET['n']) ? $_GET['n'] : '';
$recipientcomment = isset($_GET['c']) ? $_GET['c'] : '';
$recipientwebsite = isset($_GET['url']) ? $_GET['url'] : '';
$tags = isset($_GET['t']) ? $_GET['t'] : '' ;
$subscriptionEmailToken = isset($_GET['token']) ? $_GET['token'] : '' ;
$data = array();

// check speciaal registering email token
if ($subscriptionEmailToken != Settings::$subscriptionEmailToken) {
    die('Invalid registering token');
}

/*
$recipientmail = filter_var($recipientmail, FILTER_SANITIZE_EMAIL);
if (filter_var($recipientmail, FILTER_VALIDATE_EMAIL) === false) {
    die(Settings::$subscribeErrorMessage);
}
*/
$pattern = "/[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})/i";
if (!preg_match($pattern, $recipientmail)) {
    die(Settings::$subscribeErrorMessage);
}

$recipientname = $app->clearSQL($recipientname);
$recipientcomment = $app->clearSQL($recipientcomment);
$recipientwebsite = $app->clearSQL($recipientwebsite);
$tags = $app->clearSQL($tags);

$sql = "
    INSERT INTO ".PREF."_recipient (
        person,
        email,
        comment,
        website
    ) VALUES (
        :recipientname,
        :recipientmail,
        :recipientcomment,
        :recipientwebsite
    )
";
$stmt = $db->prepare($sql);
$stmt->bindParam(':recipientname', $recipientname, PDO::PARAM_STR);
$stmt->bindParam(':recipientmail', $recipientmail, PDO::PARAM_STR);
$stmt->bindParam(':recipientcomment', $recipientcomment, PDO::PARAM_STR);
$stmt->bindParam(':recipientwebsite', $recipientwebsite, PDO::PARAM_STR);
$stmt->execute();

if ($tags != '') {
    $tags = $app->clearSQL($tags);
    $tagsArray = explode(",", $tags);
    $id = $db->lastInsertId();
    foreach ($tagsArray as $tag) {
        $stmt = $db->prepare(" select id from ".PREF."_recipient_tag where name=? ");
        $stmt->bindParam(1, $tag, PDO::PARAM_STR);
        $stmt->execute();
        $row = $stmt->fetchAll();
        if (count($row)) {
            $data = $row[0];
            $id_tag = $data['id'];

            if ($id_tag) {
                $sql = "
                    INSERT INTO ".PREF."_recipient_tag_conn (
                        id_recipient,
                        id_tag
                    ) VALUES (
                        :id_recipient,
                        :id_tag
                    )
                ";
                $stmt = $db->prepare($sql);
                $stmt->bindParam(':id_recipient', $id, PDO::PARAM_STR);    
                $stmt->bindParam(':id_tag', $id_tag, PDO::PARAM_STR);
                $stmt->execute();
            }
        }
    }
}

// notify admin if needed
if (Settings::$adminSubscribtionNotify == '1' && Settings::$adminMail != '')  {
    
    // in case of header double end of line problems when email is sending thru different servers
    $eol = $app->getSystemEOL();
    
    // Define the main headers.
    $header = "MIME-Version: 1.0".$eol;
    $header .= "Content-type: text/html; charset=UTF-8".$eol;
    $header .= "From: E-mailer system <".Settings::$subscribeEmailAddressFrom.">".$eol;
    $adminEmailMessage = base64_decode(Settings::$adminEmailMessage);
    $adminEmailMessage = str_replace('{SUBSCRIBER_EMAIL}', $recipientmail, $adminEmailMessage);
    $adminEmailMessage = str_replace('{SUBSCRIBER_NAME}', $recipientname, $adminEmailMessage);
    $adminEmailMessage = str_replace('{SUBSCRIBER_COMMENT}', $recipientcomment, $adminEmailMessage);
    $adminEmailMessage = str_replace('{SUBSCRIBER_WEBSITE}', $recipientwebsite, $adminEmailMessage);
    $adminEmailMessage = str_replace('{SUBSCRIBER_TAGS}', $tags, $adminEmailMessage);
    $adminEmailMessage = str_replace('{CURRENT_YEAR}', date("Y"), $adminEmailMessage);
    $adminEmailMessage = str_replace('{CURRENT_MONTH}', date("m"), $adminEmailMessage);
    $adminEmailMessage = str_replace('{CURRENT_DAY}', date("d"), $adminEmailMessage);
    
    mail(Settings::$adminMail, "E-mailer system", $adminEmailMessage, $header);
}


// redirect to url from params
header("Location: ".Settings::$subscribeRedirectConfirmedTo);
exit();


