<?php

defined('_MAILING') or die('Restricted access');

$id_campaigns = explode('_', $_POST['id_campaign']);
$id_campaign = end($id_campaigns);

$stmt = $db->prepare(" select count(id_campaign) as qty from ".PREF."_campaign_rec_conn where id_campaign=? and status = '0' ");
$stmt->bindParam(1, $id_campaign, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();
$remaining = (int)($row[0]['qty']);

if ($remaining == 0) {
    // update campaign data
    $sql = " UPDATE ".PREF."_campaign SET status = '2' WHERE id = :id ";
    $stmt = $db->prepare($sql);              
    $stmt->bindParam(':id', $id_campaign, PDO::PARAM_INT);
    $stmt->execute(); 
}

$stmt = $db->prepare(" select recipient_qty from ".PREF."_campaign where id=? ");
$stmt->bindParam(1, $id_campaign, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetchAll();
$total = (int)$row[0]['recipient_qty'];

$number = 100 - $remaining * (100 / $total);

echo number_format($number, 2, ',', '').'%';
