<?php

defined('_MAILING') or die('Restricted access');

$id_campaign = (int)($_GET['c']);
$id_recipient = (int)($_GET['r']);

if ($id_campaign == 0 || $id_recipient == 0) {
    exit();
}

$sql = "
    UPDATE ".PREF."_campaign_rec_conn SET 
        status = '2',
        ip_receiver = '".$_SERVER["REMOTE_ADDR"]."'
    WHERE 1
        and id_campaign = :id_campaign
        and id_recipient = :id_recipient
";
$stmt = $db->prepare($sql);
$stmt->bindParam(':id_campaign', $id_campaign, PDO::PARAM_STR);
$stmt->bindParam(':id_recipient', $id_recipient, PDO::PARAM_STR);
$stmt->execute(); 

// get recipient data
$stmt = $db->query(" SELECT * from ".PREF."_recipient WHERE id = '".$id_recipient."' ");
$stmt->execute();
$row = $stmt->fetchAll();
$recipient_name = $row[0]['person'];
$recipient_email = $row[0]['email'];
$recipient_txt_only = (int)$row[0]['txt_only'];
$recipient_name_arr = explode(' ', $row[0]['person']);
$recipient_name1 = isset($recipient_name_arr[0]) ? $recipient_name_arr[0] : '';
$recipient_name2 = isset($recipient_name_arr[1]) ? $recipient_name_arr[1] : '';
$recipient_name3 = isset($recipient_name_arr[2]) ? $recipient_name_arr[2] : '';
$recipient_email = $row[0]['email'];
$recipient_txt_only = (int)$row[0]['txt_only'];
$recipient_description = $row[0]['comment'];
$recipient_website = $row[0]['website'];
$recipient_f01 = $row[0]['f01'];
$recipient_f02 = $row[0]['f02'];
$recipient_f03 = $row[0]['f03'];

// get template data
$stmt = $db->query(" SELECT * FROM ".PREF."_campaign WHERE id = '".$id_campaign."' ");
$stmt->execute();
$row = $stmt->fetchAll();
$id_template = $row[0]['id_template'];
$campaign_name = $row[0]['name'];
$id_sender   = $row[0]['id_sender'];

// get sender data
$stmt = $db->query(" SELECT * from ".PREF."_sender WHERE id= '".$id_sender."' ");
$stmt->execute();
$row = $stmt->fetchAll();
$sender_name = $row[0]['name'];
$sender_email = $row[0]['email'];

// get template data details
$stmt = $db->query(" SELECT * from ".PREF."_template WHERE id = '".$id_template."' ");
$stmt->execute();
$row = $stmt->fetchAll();
$email_subject = $row[0]['subject'];
$email_content_html	= $row[0]['content_html'];
$email_content_txt	= $row[0]['content_txt'];

// set up email tracker
if ((int)(Settings::$enableTracking)) {
    $tracker_script = HTTP.'://'.$_SERVER['SERVER_NAME'].$_SERVER['SCRIPT_NAME'].'?manage=campaign&adata=modify&action=track&c='.$id_campaign.'&r='.$id_recipient;
    $email_tracker = '<img src="'.$tracker_script.'" width="0" height="0">';
}else{
    $email_tracker = '';
}

// set up click link
$click_link = HTTP.'://'.$_SERVER['SERVER_NAME'].$_SERVER['SCRIPT_NAME'].'?manage=campaign&adata=modify&action=click&c='.$id_campaign.'&r='.$id_recipient.'&link=';
$email_content_html = str_replace('href="', 'href="'.$click_link, $email_content_html);


// set up unsubscribe link
$unsubscribe_link = 'index.php?manage=campaign&adata=modify&action=unsubscribe&c='.$id_campaign.'&r='.$id_recipient;

// prepare browser content
$subject = str_replace('{RECIPIENT_NAME}', $recipient_name, $email_subject);
$message_html = str_replace('{RECIPIENT_NAME}', $recipient_name, $email_content_html);
$message_html = str_replace('{UNSUBSCRIBE}', $unsubscribe_link, $message_html);
$message_html = str_replace('{RECIPIENT_NAME_1}', $recipient_name1, $message_html);
$message_html = str_replace('{RECIPIENT_NAME_2}', $recipient_name2, $message_html);
$message_html = str_replace('{RECIPIENT_NAME_3}', $recipient_name3, $message_html);
$message_html = str_replace('{RECIPIENT_EMAIL}', $recipient_email, $message_html);
$message_html = str_replace('{RECIPIENT_DESCRIPTION}', $recipient_description, $message_html);
$message_html = str_replace('{RECIPIENT_WEBSITE}', $recipient_website, $message_html);
$message_html = str_replace('{F0}', $recipient_website, $message_html);
$message_html = str_replace('{F1}', $recipient_f01, $message_html);
$message_html = str_replace('{F2}', $recipient_f02, $message_html);
$message_html = str_replace('{F3}', $recipient_f03, $message_html);
$message_html = str_replace('{UNSUBSCRIBE}', $unsubscribe_link, $message_html);
$message_html = str_replace('{BROWSER_VIEW}', '', $message_html);
$message_html = str_replace('{CAMPAIGN_NAME}', $campaign_name, $message_html);
$message_html = str_replace('{SENDER_NAME}', $sender_name, $message_html);
$message_html = str_replace('{SENDER_EMAIL}', $sender_email, $message_html);
$message_html = str_replace('{CURRENT_YEAR}', date("Y"), $message_html);
$message_html = str_replace('{CURRENT_MONTH}', date("m"), $message_html);
$message_html = str_replace('{CURRENT_DAY}', date("d"), $message_html);

// update campaign data
$sql = "
    UPDATE ".PREF."_campaign SET
        date_start = '".date("Y-m-d H:i:s", time())."',
        status = '1'
    WHERE id = :id
";
$stmt = $db->prepare($sql);
$stmt->bindParam(':id', $id_campaign, PDO::PARAM_INT);
$stmt->execute();


// update campaign recipient connection data
$sql = "
    UPDATE ".PREF."_campaign_rec_conn SET
        date_sent = '".date("Y-m-d H:i:s", time())."',
        status = '1'
    WHERE 1
        and id_campaign = :id_campaign
        and id_recipient = :id_recipient
";
$stmt = $db->prepare($sql);
$stmt->bindParam(':id_campaign', $id_campaign, PDO::PARAM_INT);
$stmt->bindParam(':id_recipient', $id_recipient, PDO::PARAM_INT);
$stmt->execute();

// show email on web browser
echo "
    <!DOCTYPE html>
    <html>
        <head>
            <title>".$subject."</title>
            <meta http-equiv='content-type' content='text/html;charset=utf-8' />
        </head>
        <body>
            ".$message_html."
            ".$email_tracker."
        </body>
    </html>
";


exit();
