<?php

defined('_MAILING') or die('Restricted access');

if (DEMO_MODE) {
    header("Location: index.php?manage=blacklist&action=list");
    exit();
}

$app->checkToken();

try {
    // 1 - domain
    // 2 - ip
    $type = (int) $_POST['blacklisttype'];
    $delimiter = isset($_POST['delimiter']) ? $_POST['delimiter'] : ",";
    $maxLineLength = (int) isset($_POST['maxlinelength']) > 0 ? (int) $_POST['maxlinelength'] : 256;
    list($filenamecsv, $extensioncsv) = explode(".",$_FILES["file"]["name"]);
    
    if (($handle = fopen($_FILES["file"]["tmp_name"], "r")) !== FALSE) {
        while (($data = fgetcsv($handle, $maxLineLength, $delimiter)) !== FALSE) {

            $value = $data[0];
            $sql = "
                INSERT INTO ".PREF."_blacklist (
                    value,
                    type
                ) VALUES (
                    :value,
                    :type
                )
            ";
            $stmt = $db->prepare($sql);
            $stmt->bindParam(':value', $value, PDO::PARAM_STR);
            $stmt->bindParam(':type', $type, PDO::PARAM_INT);
            $stmt->execute();
        }
        fclose($handle);
    }
    header("Location: index.php?manage=blacklist&action=list");
        
} catch (Exception $e) {
    echo 'ERROR: ',  $e->getMessage(), "\n";
}
