"use strict";

$(document).ready(function() {

    // modal element
    $('#recipientDelete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget);
        var recipientname = button.data('recipientname');
        var recipientid = button.data('recipientid');
        var recipientemail = button.data('recipientemail');
        var modal = $(this);
        modal.find('.recipientname').val(recipientname + ', (' + recipientemail + ')');
        modal.find('.recipientid').val(recipientid);
    });
        
    $.fn.dataTableExt.oStdClasses.sPageButton = "btn btn-default";
    $('.site_title i').addClass('fa-spin');
    var oTable = $('#recipients').DataTable({
        stateSave: true,
        language: dataTableTranslation,
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "index.php?manage=recipient&data=modify&action=getlist",
            "type": "POST",
            "data":{
                 "csrf_token": "<?php echo $app->getToken();?>"
            }, 
        },
        "columns": [
            { "data": "id" },
            { "data": "person" },
            { "data": "email" },
            { "data": "tag" },
            { "data": "comment" },
            { "data": "button" }
        ],
        "fnDrawCallback": function( oSettings ) {
          $('.site_title i').removeClass('fa-spin');
        }
        
    });
    
    $("div.dataTables_filter").append("<a id='mySearch' class='btn btn-primary btn-xs'>go</a>");
    $("div.dataTables_filter input").unbind();
    $("div.dataTables_filter input").on('keydown', function(e) {
        if (e.which == 13) {
            oTable.search( $("div.dataTables_filter input").val()).draw();
        }
    });
    $("#mySearch").on('click', function(e) {
            oTable.search( $("div.dataTables_filter input").val()).draw();
    });

});